package cn.freemud.entities.dto.shoppingCart;

import cn.freemud.entities.dto.OrderProductAddInfo;
import cn.freemud.entities.vo.SubtractStockVO;
import com.alibaba.fastjson.JSON;
import lombok.Builder;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;


@Data
public class ShoppingCartGoodsDto {

    /**
     * 购物车实际选择商品，包含加价购商品
     */
    List<CartGoodsDetailDto> products;
    /**
     * 原总价
     */
    private Long originalTotalAmount;
    /**
     * 现总价
     */
    private Long totalAmount;
    /**
     * 总折扣价(优惠价)
     */
    private Long totalDiscountAmount;
    /**
     * 包装费
     */
    private Long packageAmount;

    /**
     * 积分扣减金额
     */
    private Long scoreReduceAmount;

    /**
     * 抵用积分
     */
    private Long reduceScore;
    /**
     * 第一次使用会员卡需多支付的金额 单位为分
     */
    private Integer memberCardAmount;

    /**
     * 会员卡原价
     */
    private Integer cardOriginalAmount;

    /**
     * 会员卡优惠金额
     */
    private Integer cardDiscountAmount;
    /**
     * 订单享受的促销活动
     */
    List<ActivityDiscountsDto> activityDiscountsDtos;
    /**
     * 活动库存
     */
    private List<SubtractStockVO> stocks;

    /**
     * 配送费
     */
    private Long deliveryAmount;

    /**
     * 减免后配送费
     */
    private Long discountDeliveryAmount;

    /**
     * 满多少额度 减免
     */
    private Long thresholdAmount;

    /**
     * 是否参加满额减免
     */
    @Builder.Default
    private Boolean isDiscountDelivery = false;

    /**
     * 配送费活动号
     *
     */
    private String discountDeliveryActivityCode;

    /**
     * 麦咖啡-咖啡月卡价格
     */
    private Long payCardFee;


    /**
     * 送集点
     */
    private SendPoint sendPoint;

    /**
     * 麦咖啡-买三赠一券费用
     */
    private Long buyThreeGiveOneCouponFee;


    @Data
    public static class CartGoodsDetailDto {
        /**
         * spuId
         */
        private String spuId;
        /**
         * spuId  如果是单品 skuId=spuId
         */
        private String skuId;
        /**
         * 商品的名称
         */
        private String spuName;
        /**
         * 如果是单品 skuName=spuName
         */
        private String skuName;
        /**
         * 商品行原始价格
         */
        private Long originalPrice;
        /**
         * 商品图片
         */
        private String picture;
        /**
         * 商品的数量
         */
        private Integer qty;
        /**
         * 商品行优惠总金额=数量*单个商品优惠金额
         */
        private Integer totalDiscountAmount;
        /**
         * 是否包含商品券
         */
        private Boolean hasProductCoupon = false;
        /**
         * 商品券code
         */
        private String couponCode;
        /**
         * 1.5.5版本添加
         * 商品参与活动类型(61:买一赠一)
         */
        private Integer activityType;

        /**
         * 1.6.0 版本增加  节点ID
         */
        private String nodeId;
        /**
         * 1.6.0 版本增加 分类名
         */
        private String categoryName;

        /**
         * 套餐--父级商品Id
         */
        private String parentProductId;

        /**
         * 套餐--type:6
         */
        private Integer productType;

        /**
         * 是否是套餐内固定商品
         */
        private Boolean isFixedProduct;

        /**
         * 三方商品编号
         */
        private String customerCode;

        /**商品货号**/
        private String productCode;

        /** 商品统计分类编号**/
        private String classificationId;

        private String classificationName;
        /**
         * 是否限制库存
         * 用于创建订单时，是否扣减库存
         */
        private boolean isStockLimit;
        /**
         * 商品重量
         */
        private Double weight;

        /**
         * 商品行记录
         */
        private Integer sequence;

        /**
         * 商品的单位
         */
        private String unit;

        /**
         * 费率
         */
        private double tax;

        private String taxId;

        /**
         * 加购人ID
         */
        private String userId;

        /**
         * 加购人openId
         */
        private String openId;

        /**
         * 加购人昵称
         */
        private String userName;

        /**
         * 加购人头像
         */
        private String photoUrl;

        /**
         * 加购人包装费
         */
        private Long packPrice;

        /**
         * 购物车行id
         */
        private String cartGoodsUid;

        /**
         * 配料或属性
         */
        private List<CartGoodsDetailDto.CartGoodsExtra> extraList = new ArrayList<>(0);

        /**
         * 配料或属性
         */
        private List<CartGoodsDetailDto.CartGoodsExtra> specialExtra = new ArrayList<>(0);
        /**
         * 商品行享受的促销活动
         */
        List<ActivityDiscountsDto> activityDiscountsDtos;
        /**
         * 套餐子商品
         */
        private List<CartGoodsDetailDto> comboProducts;

        private List<CartGoodsDetailDto> materialList;


        /**
         * 拼单买一赠一标记赠品是那个商品送的 originalGoodsUid
         */
        private String originalGoodsUid;

        @Data
        public final static class CartGoodsExtra {
            /**
             * 属性Id
             */
            private String attributeId;
            /**
             * 属性名
             */
            private String attributeName;
            /**
             * 入机code
             */
            private String specialCode;
        }


        /**
         * 获取extras attributeNames
         */
        public String getAttributeNames() {
            String extras = "";
            if (CollectionUtils.isNotEmpty(this.extraList)) {
                extras = extraList.stream().map(CartGoodsDetailDto.CartGoodsExtra::getAttributeName).collect(Collectors.joining("/"));
            }
            return JSON.toJSONString(OrderProductAddInfo.builder().attributeNames(extras).build());
        }

    }

    @Data
    public static class SendPoint{

        private String activityCode;
        private Date endTime;
        private Integer sendPoint;
        private Integer maxNum;
        private Integer validityDateDays;


    }

}
