package com.freemud.sdk.api.assortment.shoppingcart.constant;

import java.math.BigDecimal;

/**
 * All rights Reserved, Designed By www.freemud.com
 *
 * @version V1.0
 * @Title:
 * @Package: com.freemud.card.sdk.comm
 * @Descripttion:
 * @author: genyou.cui
 * @date: 2018/12/17 14:06
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目.
 */
public interface CouponConstant {

    /**
     * 是否可用
     */
    Integer CAN_USE = 0;//可用
    Integer CAN_NOT_USE = 1;//不可用
    Integer LIMIT_USE = 2;//商品限制可用

    String PRODUCT_WHITE = "0";
    String PRODUCT_BLACK = "1";
    String VIRTUAL_PRODUCT = "1234567";
    String COUPON_PARTNER_APP_KEY = "kgd:coupon:appKey:partner:";
    BigDecimal HUNDRED = new BigDecimal(100);

    enum FmStatusCode {
        COUPON_NORMAL(10, "该券正常"),
        COUPON_EXISTORNOTSTART(11, "优惠券不存在或者活动未开始"),
        COUPON_EXPIRED(12, "优惠券已过期"),
        STATUS_RECOVERY(14, "优惠券已经核销或者不存在"),
        STATUS_CODE_15(15, "优惠券未激活"),
        STATUS_CODE_16(16, "该优惠券不能和其它优惠券混合使用"),
        STATUS_CODE_21(21, "参数错误"),
        STATUS_CODE_31(31, "商品不匹配或核销数量超出可用数量"),
        STATUS_CODE_32(32, "优惠券必须一次性核销"),
        TRANS_NOT_EXIST(41, "交易不存在"),
        STATUS_CODE_51(51, "该门店不适用此券"),
        STATUS_CODE_52(52, "商品类别不能使用优惠券"),
        SUCCESS(100, "成功"),
        STATUS_CODE_101(101, "部分凭证码核销失败"),
        STATUS_CODE_102(102, "多次请求,幂等返回第一次响应数据"),
        STATUS_CODE_201(201, "支付账号不存在"),
        STATUS_CODE_202(202, "账户异常"),
        STATUS_CODE_203(203, "账号余额不足"),
        STATUS_CODE_204(204, "交易超时或者支付平台异常"),
        STATUS_CODE_205(205, "条码无效"),
        STATUS_CODE_206(206, "退款金额高于支付金额"),
        STATUS_CODE_207(207, "操作不支持"),
        STATUS_CODE_500(500, "系统错误"),
        STATUS_CODE_505(505, "未知返回码"),
        STATUS_CODE_506(506, "验证失败");

        FmStatusCode(int statusCode, String message) {
            this.statusCode = statusCode;
            this.message = message;
        }

        private int statusCode;
        private String message;

        public int getStatusCode() {
            return statusCode;
        }

        public String getMessage() {
            return message;
        }

        public static FmStatusCode getInfoByCode(int code) {
            for (FmStatusCode fmStatusCode : values()) {
                if (code == fmStatusCode.getStatusCode()) {
                    return fmStatusCode;
                }
            }
            return null;
        }
    }

    enum MemberCode {
        SUCCESS("100", "成功"),
        ERROR("101", "获取失败"),
        ;
        private String code;
        private String msg;

        MemberCode(String code, String msg) {
            this.code = code;
            this.msg = msg;
        }

        public String getCode() {
            return code;
        }

        public String getMsg() {
            return msg;
        }
    }

    enum SourceFlag {
        wechat("60"),
        xinmeida("61"),
        tmall("62"),
        isaas("63"),
        ;
        private String code;

        SourceFlag(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }
    }

}
