package cn.freemud.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/10/18 下午6:17
 * @description : 发票配置 渠道映射关系
 */
@AllArgsConstructor
@Getter
public enum OrderInvoiceConfigEnum {
    /**
     * 百旺云渠道类型
     */
    BAIWANGYUN("baiwangyun", "10099");

    private String channelType;
    private String clientCode;

    public static String getClientCode(String channelType) {
        OrderInvoiceConfigEnum orderInvoiceConfigEnum = Arrays.stream(OrderInvoiceConfigEnum.values())
                .filter(e -> e.getChannelType().equals(channelType))
                .findFirst()
                .orElseGet(() -> BAIWANGYUN);
        return orderInvoiceConfigEnum.getClientCode();
    }
}
