package cn.freemud.service.thirdparty;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.PurchasePaidRequestDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: CustomerApplicationClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: yuhao.chi
 * @date: 2019/5/30 13:11
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
@FeignClient(name = "customer-application-service",url = "${saas.customScoreClient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CustomerApplicationClient {

    @PostMapping(value = "membercard/purchasePaid")
    BaseResponse purchasePaid(PurchasePaidRequestDto requestDto);

}
