package cn.freemud.management.service.impl;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import cn.freemud.management.entities.dto.response.order.OrderManagerResponse;
import cn.freemud.management.entities.dto.response.pay.PayRefundResponse;
import cn.freemud.management.enums.ResponseResult;
import cn.freemud.management.service.OrderManagerService;
import cn.freemud.management.service.handle.*;
import cn.freemud.management.util.ResponseUtil;
import com.freemud.sdk.api.assortment.message.enums.OrderType;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: McoffeMangerServiceImpl
 * @Package cn.freemud.management.service.impl
 * @Description:
 * @author: shuhu.hou
 * @date: 2020/8/9 15:26
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
public class McCafeMangerServiceImpl implements OrderManagerService {
    @Resource
    private SaasOrderHandle saasOrderHandle;
    @Resource
    private CouponHandle couponHandle;
    @Resource
    private DeliveryHandle deliveryHandle;
    @Resource
    private PaymentHandle paymentHandle;
    @Resource
    private StockHandle stockHandle;

    @Override
    public BaseResponse<OrderManagerResponse> orderConfirm(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean) {
        OrderManagerRequest orderManagerRequest =new OrderManagerRequest();
        BeanUtils.copyProperties(request,orderManagerRequest);
        // 订单接单
        saasOrderHandle.orderConfirm(orderManagerRequest, orderBean);

        //支付成功已经 创建配送单
        if (!Objects.equals(orderBean.getOrderType(), OrderType.TAKE_OUT.getCode())) {
            if (StringUtils.isNotEmpty(request.getPickUpGoodsNo())){
                //更新取餐码
                saasOrderHandle.updatePickUpGoodNo(request,orderBean);
            }

            // 异步核销券码
            couponHandle.asyncVerificationCoupon(orderBean);

        }
        return ResponseUtil.success();
    }

    @Override
    public BaseResponse<OrderManagerResponse> orderReject(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean) {
        OrderManagerRequest orderManagerRequest =new OrderManagerRequest();
        BeanUtils.copyProperties(request,orderManagerRequest);
        //根据是否是外卖单来判断
        if (Objects.equals(orderBean.getOrderType(), OrderType.TAKE_OUT.getCode())) {
            // 订单接单
            BaseResponse<OrderManagerResponse> orderManagerResponseBaseResponse = orderConfirm(request, orderBean);
            if (ResponseResult.SUCCESS.equals(orderManagerResponseBaseResponse.getCode())){
                //通知配送服务停单
                deliveryHandle.haltedDelivery(orderBean);
            }

        }else {
            //支付退款
            PayRefundResponse refundResponse = paymentHandle.refund(orderManagerRequest, orderBean);
            //订单拒单
            saasOrderHandle.orderReject(orderManagerRequest, refundResponse, orderBean);
            //冲正库存
            stockHandle.revert(orderManagerRequest, orderBean);
            // 券码解冻
            couponHandle.unlock(orderBean);
        }
        return ResponseUtil.success();
    }

    /**
     * 订单配送
     *
     * @param request
     * @param orderBean
     * @return
     */
    @Override
    public BaseResponse<OrderManagerResponse> orderDelivery(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean) {
        return ResponseUtil.success();
    }

    /**
     * 订单完成
     *
     * @param request
     * @param orderBean
     * @return
     */
    @Override
    public BaseResponse<OrderManagerResponse> orderAffirm(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean) {
        return ResponseUtil.success();
    }



    /**
     * 同意退款
     *
     * @param request
     * @param orderBean
     * @return
     */
    @Override
    public BaseResponse<OrderManagerResponse> orderAgreeRefund(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean) {
        return null;
    }

    /**
     * 拒绝退款
     *
     * @param request
     * @param orderBean
     * @return
     */
    @Override
    public BaseResponse<OrderManagerResponse> orderRejectRefund(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean) {
        return null;
    }
}
