package cn.freemud.service.impl.calculate;

import cn.freemud.constant.ShoppingCartConstant;
import cn.freemud.entities.dto.UserLoginInfoDto;
import cn.freemud.entities.dto.activity.ActivityQueryDto;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountResponseDto;
import cn.freemud.entities.vo.CartGoods;
import cn.freemud.entities.vo.CouponPromotionVO;
import cn.freemud.entities.vo.ShoppingCartGoodsResponseVo;
import cn.freemud.entities.vo.ShoppingCartInfoRequestVo;
import cn.freemud.service.impl.calculate.promotion.*;
import com.freemud.sdk.api.assortment.shoppingcart.enums.BusinessTypeEnum;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: cn.freemud.service.impl.calculate CalculationSharingCartService
 * @Description: TDO 描述....
 * @author: family
 * @date: 2020/9/7
 * @Copyright: www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
@Slf4j
public class CalculationSharingCartService {

    @Autowired
    private CouponSharingService promotionSharingService;

    @Autowired
    private FullSharingService fullSharingService;

    @Autowired
    private ScoreSharingService scoreSharingService;

    @Autowired
    private DeliverySharingService deliverySharingService;

    @Autowired
    private GiftSharingService giftSharingService;

    @Autowired
    private AdditionSharingService additionSharingService;
    @Autowired
    private CalculationCommonService calculationCommonService;

    /**
     * 响应购物车价格计算依赖促销
     */
    public void distribute(CalculationSharingDiscountResponseDto.CalculationDiscountResult discountResult
            , List<CartGoods> cartGoodsList
            , ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo
            , ShoppingCartInfoRequestVo shoppingCartInfoRequestVo
            , UserLoginInfoDto userLoginInfoDto
            , CouponPromotionVO couponPromotionVO
            , ActivityQueryDto activityQueryDto
            , String menuType
            , Long deliveryAmount
            , String opt) {

        /**
         * 用促销价格初始化购物车行记录成交价
         */
        calculationCommonService.initShoppingCart(discountResult, cartGoodsList, shoppingCartGoodsResponseVo);

        /**
         * 可用券及券折扣
         */
        promotionSharingService.updateShoppingCartGoodsDiscount(discountResult, cartGoodsList, shoppingCartGoodsResponseVo, couponPromotionVO);

        /**
         * 满减处理
         */
        fullSharingService.fullResponse(discountResult,cartGoodsList,shoppingCartGoodsResponseVo,activityQueryDto);

        /**
         * 买赠
         */
        giftSharingService.giftResponse(discountResult, cartGoodsList, shoppingCartInfoRequestVo, activityQueryDto);

        /**
         * 加价购
         */
        additionSharingService.additionResponse(discountResult,cartGoodsList,shoppingCartGoodsResponseVo,shoppingCartInfoRequestVo);
        /**
         * 积分抵扣
         */
        scoreSharingService.scoreResponse(discountResult, shoppingCartGoodsResponseVo, userLoginInfoDto, shoppingCartInfoRequestVo);
        if (BusinessTypeEnum.SAAS_DELIVERY.getCode().equals(menuType)) {
            deliverySharingService.deliveryResponse(discountResult, activityQueryDto, shoppingCartGoodsResponseVo, deliveryAmount);
        }


        /**
         * 可选搭配的价格累加到套餐的成交价上
         */
        this.combineGroupRowAmount(cartGoodsList);

        /**
         * 特价类型超出部分提示
         */
        calculationCommonService.drawSurpassDiscountInfo(discountResult, shoppingCartGoodsResponseVo);
        if (ShoppingCartConstant.ADD_AND_UPDATE.equals(opt)) {
            calculationCommonService.setAddAndUpdateResponse(cartGoodsList, shoppingCartGoodsResponseVo, shoppingCartInfoRequestVo, ShoppingCartConstant.ADD_AND_UPDATE);
        } else if (ShoppingCartConstant.QUERY_INFO.equals(opt)) {
            calculationCommonService.setAddAndUpdateResponse(cartGoodsList, shoppingCartGoodsResponseVo, shoppingCartInfoRequestVo, ShoppingCartConstant.ADD_AND_UPDATE);
            calculationCommonService.addNeedCardAmount(shoppingCartInfoRequestVo, shoppingCartGoodsResponseVo);
        }

    }



    /**
     * 初始化价格
     */
    private void initShoppingCart(CalculationSharingDiscountResponseDto.CalculationDiscountResult discountResult
            , List<CartGoods> cartGoodsList
            , ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo) {

        /**
         * 使用促销算价赋值行记录
         */
        List<CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods> goods = discountResult.getGoods();
        long totalOriginalAmount = 0L,totalAmount = 0L,totalPackageAmount = 0L;
        long originalAmount = 0L,amount = 0L,packageAmount =0L;
        for (CartGoods cartGoods : cartGoodsList) {
            originalAmount = 0L;
            amount = 0L;
            packageAmount =0L;
            CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods find = goods.stream().filter((k) -> k.getCartGoodsUid().equals(cartGoods.getCartGoodsUid())).findFirst().get();
            if (find==null) continue;
            //成交价行记录
            amount += find.getRealAmount()*cartGoods.getQty();
            cartGoods.setAmount(amount);
            totalAmount += amount;
            //原价行记录
            originalAmount = cartGoods.getOriginalPrice() * cartGoods.getQty();
            cartGoods.setOriginalAmount(originalAmount);
            totalOriginalAmount += originalAmount;
            //包装费行记录
            packageAmount = cartGoods.getPackPrice() * cartGoods.getQty();
            cartGoods.setPackPrice(packageAmount);
            totalPackageAmount += packageAmount;
        }
        shoppingCartGoodsResponseVo.setOriginalTotalAmount(discountResult == null ? totalOriginalAmount : discountResult.getOriginalTotalAmount());
        shoppingCartGoodsResponseVo.setTotalAmount(discountResult == null ? totalAmount : discountResult.getTotalAmount());
        shoppingCartGoodsResponseVo.setNewPackAmount(totalPackageAmount);
        shoppingCartGoodsResponseVo.setTotalDiscountAmount(discountResult == null ? 0L : discountResult.getTotalDiscountAmount());
    }

    /**
     * 套餐\可选搭配\小料成交价
     * productGroupList->可选搭配
     * productComboList->固定套餐搭配
     */
    public void buildCombination(CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods goods, CartGoods cartGoods) {
        /*小料
        if (cartGoods.getProductMaterialList().size()>0 && goods.getSmallMaterial().size()>0) {
            for (CartGoods.MaterialGoods mg : cartGoods.getProductMaterialList()) {
                for (CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods.SmallMaterial mt : goods.getSmallMaterial()) {
                    if (1==mt.getType() && mg.getSpuId().equals(mt.getGoodsId())) {
                        mg.setAmount(mt.getRealAmount().longValue());
                        break;
                    }
                }
            }
        }
         */
        // 将可选搭配的价格还原到主行记录
        if (cartGoods.getProductGroupList().size()>0 && goods.getSmallMaterial().size()>0) {
            long a = 0L;
            for (CartGoods.ComboxGoods comBox : cartGoods.getProductGroupList()) {
                for (CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods.SmallMaterial mt : goods.getSmallMaterial()) {
                    if (2==mt.getType() && comBox.getGoodsId().equals(mt.getGoodsId())) {
                        //mt
                    }
                }
            }
        }
    }


    /**
     * 可选搭配的成交价合并到主商品上
     * @param cartGoodsList
     */
    private void combineGroupRowAmount(List<CartGoods> cartGoodsList) {
        if (CollectionUtils.isEmpty(cartGoodsList)) return;
        for (CartGoods cartGoods : cartGoodsList) {
            long row = 0L;
            if (CollectionUtils.isEmpty(cartGoods.getProductGroupList())) continue;
            for (CartGoods.ComboxGoods com : cartGoods.getProductGroupList()) {
                row += com.getAmount();
            }
            cartGoods.setAmount(cartGoods.getAmount()+row);
        }
    }
}
