package cn.freemud.management.enums;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: PayRefundStatus
 * @Package cn.freemud.enums
 * @Description:
 * @author: jiaxin.liu
 * @date: 2019/5/27 15:09
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public enum CouponReqTypeEnum {
    QUERY(0,"查询"),
    CANCEL_REDEEM(3,"冲正"),
    REDEEM(71,"核销"),
    LOCK(89,"锁定"),
    UNLOCK(90,"解锁"),
    ;

    private Integer code;
    private String desc;

    CouponReqTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CouponReqTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (CouponReqTypeEnum payStatus : values()) {
            if (payStatus.getCode().equals(code)) {
                return payStatus;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
