/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderAccountType
 * @Package cn.freemud.enums
 * @Description:
 * @author: liming.guo
 * @date: 2018/8/7 17:30
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.sdk.api.assortment.order.enums;

import java.util.Objects;

public enum OldOrderAccountType {

    DELIVERY_AMOUNT(1, "配送费", "DELIVERY_AMOUNT"),
    BUY_DISCOUNT(2, "满减优惠", "BUY_DISCOUNT"),
    PACK_AMOUNT(3, "包装费", "PACK_AMOUNT"),
    COUPON(5, "代金券", "COUPON"),
    PRODUCT_COUPON(6, "商品券", "PRODUCT_COUPON"),
    DISCOUNT_COUPON(7, "折扣券", "DISCOUNT_COUPON"),
    DRIVER_FEE(7, "骑手小费", "DRIVER_FEE"),
    DISCOUNT_AMOUNT(21, "限时折扣", "DISCOUNT_AMOUNT"),
    PREMIUM_EXCHANGE(22, "加价购", "PREMIUM_EXCHANGE"),
    SECOND_DISCOUNT(23, "第二件N折", "SECOND_DISCOUNT"),
    BUYM_SENDN(24, "买M赠N", "BUYM_SENDN"),
    CUSTOMER_SCORE(4, "积分兑换", "CUSTOMER_SCORE"),
    WEIXIN(203,"微信优惠","WECHAT_DISCOUNT"),
    ALIPAY(204,"支付宝优惠","ALIPAY_DISCOUNT"),
    CARD_ORIGINAL_AMOUNT(25, "会员卡原价", "CARD_ORIGINAL_AMOUNT"),
    SET_MEAL(211, "套餐商品优惠", "SET_MEAL"),
    CARD_DISCOUNT_AMOUNT(26, "会员卡优惠金额", "CARD_DISCOUNT_AMOUNT"),
    XY_DISCOUNT(104, "x件y折", "XY_DISCOUNT"),
    FULL_DISTRIBUTION_FEE(1014, "满减配送费", "FULL_DISTRIBUTION_FEE"),
    NEW_USER_DISCOUNT(101, "新用户立减", "NEW_USER_DISCOUNT"),
    TOTAL_DISCOUNT(205, "优惠总金额", "TOTAL_DISCOUNT");
    private Integer code;

    private String desc;

    private String message;

    OldOrderAccountType(Integer code, String desc, String message) {
        this.code = code;
        this.desc = desc;
        this.message = message;
    }

    public static OldOrderAccountType getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (OldOrderAccountType type : OldOrderAccountType.values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public static OldOrderAccountType getByMessage(QueryOrderAccountType accountType) {
        for (OldOrderAccountType type : OldOrderAccountType.values()) {
            if (Objects.equals(type.getMessage(), accountType.getCode())) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
