/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OpenPlatformClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: liming.guo
 * @date: 2018/8/15 18:27
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.thirdparty;

import cn.freemud.annotations.IgnoreFeignLogAnnotation;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.dto.*;
import cn.freemud.entities.dto.openplatform.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "MICRO-OPENPLATFORM", url = "${saas.openplatformclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface OpenPlatformClient {

//    @PostMapping("/openPlatform/getWxappUserInfo")
//    GetWxappUserInfoResponseDto getOpenPlatformUserInfo(@RequestBody GetWxappUserInfoDto getWxappUserInfoDto);
//
//    @PostMapping("/openPlatform/getAccessTokenAndTemplateId")
//    GetWxappAccessTokenResponseDto getAccessTokenAndTemplateId(@RequestBody GetWxappAccessTokenDto getWxappAccessTokenDto);
//
//    @PostMapping("/banner/fromAssistant/getPartnerBannerList")
//    GetBannerStoreResultDto getBannerPictureList(@RequestBody GetBannerPictureListDto getBannerPictureList);
//
//    @PostMapping("/banner/fromAssistant/getNewBannerList")
//    GetNewBannerResponseDto getNewBannerList(@RequestBody GetBannerPictureListDto bannerPictureListDto);
//
//    @PostMapping("/storeDelivery/getInfo")
//    GetStoreDeliveryResultDto getStoreDeliveryInfo(@RequestBody GetStoreDeliveryRequestDto getStoreDeliveryRequestDto);
//
//    @PostMapping("/thirdDelivery/betweenService/getDelivery")
//    GetDeliveryResponseDto getDelivery(@RequestBody GetDeliveryRequestDto getDeliveryRequestDto);
//
//    /**
//     * 加入微信卡包
//     */
//    @PostMapping("/weixincard/weixinCardForApp/addweixincardcode")
//    AddWeixinCardCodeResponseDto addWeiXinCardCode(@RequestBody AddWeixinCardCodeRequestDto requestDto);
//
//    /**
//     * 查询券是否可以加入微信卡包
//     */
//    @PostMapping("/weixincard/weixinCardForApp/addWeixinCardJudge")
//    AddWeixinCardJudgeResponseDto addWeixinCardJudge(@RequestBody AddWeixinCardJudgeRequestDto requestDto);

    /**
     * 解码code获取微信卡券对应商品信息
     * @param requestDto
     * @return
     */
    @PostMapping("/weixincard/weixinCardForApp/getProduct")
    @IgnoreFeignLogAnnotation(excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.STATUS_CODE,messageFieldName=ResponseCodeKeyConstant.MSG)
    WeixinProductResponseDto getWeixinProductRequestDto(WeixinProductRequestDto requestDto);


    /**
     * 获取小程序支付payEbCode
     * @param requestDto
     * @return
     */
//    @PostMapping("/payment/getPayEbCodeByAppId")
//    GetPayEbCodeByAppIdResponseDto getPayEbCodeByAppId(GetPayEbCodeByAppIdRequestDto requestDto);

}
