package cn.freemud.service.thirdparty;

import cn.freemud.annotations.IgnoreFeignLogAnnotation;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.ecology.VirtualBindStoreResponse;
import cn.freemud.entities.ecology.VirtualStoreRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 生态服务
 * @author: kai.ding
 * @date:  
 */
@FeignClient(name = "ECOLOGY-ADMIN-APPLICATION", url = "${saas.ecology.admin.application.feign.url}")
public interface EcologyAdminApplicationClient {

    /**
     * 获取虚拟门店
     */
    @IgnoreFeignLogAnnotation(excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.STATUS_CODE,messageFieldName=ResponseCodeKeyConstant.MSG)
    @PostMapping(value = "ecology/api/app/info/getBuyBindVirtualStore", produces = MediaType.APPLICATION_JSON_VALUE ,consumes = MediaType.APPLICATION_JSON_VALUE )
    BaseResponse<VirtualBindStoreResponse> getBuyBindVirtualStore(@RequestBody VirtualStoreRequest virtualStoreRequest);
}
