package cn.freemud.service.impl;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.constant.RedisKeyConstant;
import cn.freemud.entities.db.OpenStoreIappWxappConfig;
import cn.freemud.entities.dto.user.GetSessionUserInfoDto;
import cn.freemud.entities.vo.CustomerInfoVo;
import cn.freemud.entities.vo.OpenStoreIappWxappConfigRequestVo;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.redis.RedisCache;
import cn.freemud.service.OpenStoreIappWxappConfigService;
import cn.freemud.service.thirdparty.CustomerApplicationClient;
import cn.freemud.utils.BeanUtil;
import cn.freemud.utils.LogUtil;
import cn.freemud.utils.ResponseUtil;
import com.alibaba.fastjson.JSON;
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo;
import com.freemud.api.assortment.datamanager.manager.customer.AssortmentCustomerInfoManager;
import com.freemud.application.sdk.api.log.ApiLog;
import com.freemud.application.sdk.api.log.ErrorLog;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
//@Slf4j
public class OpenStoreIappWxappConfigServiceImpl implements OpenStoreIappWxappConfigService {

    @Autowired
    private RedisCache redisCache;

    @Autowired
    private CustomerApplicationClient customerApplicationClient;
    @Autowired
    private AssortmentCustomerInfoManager customerInfoManager;

    public BaseResponse getOpenStoreIappWxappConfig(OpenStoreIappWxappConfigRequestVo openStoreIappWxappConfigRequestVo){
        // 获取用户信息
        CustomerInfoVo assortmentCustomerInfoVo = getCustomerInfoVo(openStoreIappWxappConfigRequestVo.getSessionId());
        //缓存为空则初始化为展示备注,默认备注为空,
        OpenStoreIappWxappConfig defauleConfig = new OpenStoreIappWxappConfig();
        defauleConfig.setTakeInside(1);
        defauleConfig.setInsideRemark("");
        defauleConfig.setTakeOutRemark("");
        OpenStoreIappWxappConfig config;
        try {
            config = redisCache.hashGet(RedisKeyConstant.KGD_ORDER_OPEN_STORE_IAPP_WXAPP_CONFIG_WXAPPID_, assortmentCustomerInfoVo.getWxAppId());
            if (null == config) {
                config = new OpenStoreIappWxappConfig();
                BeanUtils.copyProperties(config,defauleConfig);
                return ResponseUtil.success(config);
            }else{
                return ResponseUtil.success(config);
            }
        }catch (Exception e){
            //异常打印日常日志，返回默认config
            ErrorLog.errorConvertJson(this.getClass(),"getOpenStoreIappWxappConfig",e);
            return ResponseUtil.success(defauleConfig);
        }
    }

    private CustomerInfoVo getCustomerInfoVo(String sessionId) {
//        GetSessionUserInfoDto getSessionUserInfoDto = new GetSessionUserInfoDto();
//        getSessionUserInfoDto.setIsGetPaid(true);
//        getSessionUserInfoDto.setSessionId(sessionId);
//        BaseResponse<CustomerInfoVo> sessionUserInfo = customerApplicationClient.getSessionUserInfo(getSessionUserInfoDto);
//        if (!ResponseResult.SUCCESS.getCode().equals(sessionUserInfo.getCode()) || sessionUserInfo.getResult() == null) {
//            throw new ServiceException(ResponseResult.NOT_LOGIN);
//        }
//        return sessionUserInfo.getResult();
        AssortmentCustomerInfoVo customerInfoVo = customerInfoManager.getCustomerInfoByObject(sessionId);
        if(customerInfoVo == null) throw new ServiceException(ResponseResult.NOT_LOGIN);
        String jsonObject = JSON.toJSONString(customerInfoVo);
        CustomerInfoVo customerInfoVo1 = JSON.parseObject(jsonObject,CustomerInfoVo.class);
//        BeanUtil.convertBean(customerInfoVo,customerInfoVo1);
        return customerInfoVo1;
    }
}
