package cn.freemud.annotations;

import java.lang.annotation.*;


@Retention(RetentionPolicy.RUNTIME)
@Target(value = {ElementType.METHOD})
@Documented
@Inherited
public @interface IgnoreFeignLogAnnotation {

    /**
     * 是否打印日志，true打印，false不打印，注意设置成false状态码和状态码信息都不会打印
     * @return
     */
    boolean printLog() default true;

    /**
     * printLog 设置成true的时候，可以排除哪些状态码的响应不用打印响应报文，只会打印状态码
     *
     * @return
     */
    String[] excludeStatusCodes() default "100";

    String statusCodeFieldName() default "code";

    String messageFieldName() default "message";

}

