package cn.freemud.service;

import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.utils.SpringBeanUtil;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.storecenter.request.vo.GetOrgTreeListRequest;
import com.freemud.application.sdk.api.storecenter.service.StoreCenterService;

import java.util.List;

public interface CommonService {

    default List<String> getOrgIds(String partnerId, String storeCode) {
        GetOrgTreeListRequest request = new GetOrgTreeListRequest();
        request.setPartnerId(partnerId);
        request.setStoreCode(storeCode);
        StoreCenterService storeCenterService = SpringBeanUtil.getBean(StoreCenterService.class);
        com.freemud.application.sdk.api.base.BaseResponse<List<String>> orgList = storeCenterService.getOrgList(request, LogThreadLocal.getTrackingNo());
        if (orgList != null && ResponseCodeConstant.RESPONSE_SUCCESS_STR.equals(orgList.getCode())) {
            return orgList.getData();
        }
        return null;
    }
}
