package cn.freemud.adapter;

import cn.freemud.entities.dto.AddProductEvaluationReqDto;
import cn.freemud.entities.vo.AddUserOrderEvaluationNewRequestVo;
import cn.freemud.utils.EmojiUtil;
import cn.freemud.utils.UnicodeUtil;
import com.freemud.application.sdk.api.ordercenter.request.evaluation.AddEvaluationReq;
import com.freemud.application.sdk.api.ordercenter.request.evaluation.AddProductEvaluationDto;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderInfoReqs;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.com
 *
 * @version V1.0
 * @Title:
 * @Package: cn.freemud.adapter
 * @Descripttion:
 * @author: shuhu.hou
 * @date: 2019/8/12
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目.
 */
@Component
public class EvaluationAdapter {

    public AddEvaluationReq convent2InsertOrderEvaluationReqDto(AddUserOrderEvaluationNewRequestVo reqVo, OrderInfoReqs orderInfo) {
        AddEvaluationReq request = new AddEvaluationReq();
        request.setCustomerName(EmojiUtil.filterEmoji(orderInfo.getUserName(),""));
        if(CollectionUtils.isNotEmpty(orderInfo.getDeliveryContactInfoList())){
            request.setCustomerMobile(orderInfo.getDeliveryContactInfoList().get(0).getMobile());
        }
        request.setCustomerPhotoUrl(reqVo.getCustomerPhotoUrl());
        request.setTaste(getDefaultValue(reqVo.getTaste()));
        request.setHealth(getDefaultValue(reqVo.getHealth()));
        request.setService(getDefaultValue(reqVo.getService()));
        request.setDeliverySpeed(getDefaultValue(reqVo.getDeliverySpeed()));
        request.setSurroundings(getDefaultValue(reqVo.getSurroundings()));
        request.setEvaluationContent(UnicodeUtil.filterSpecialChars(reqVo.getEvaluationContent()));
        request.setCreateOrderTime(new Date(Long.parseLong(orderInfo.getCreateTime())));
//        request.setModifyTime(new Date());
//        request.setCreate_time(new Date());
        request.setPartnerId(reqVo.getPartnerId());
        request.setStoreId(orderInfo.getStoreId());
        request.setStoreName(orderInfo.getStoreName());
        request.setOrderId(reqVo.getOrderId());
        request.setOrderType(orderInfo.getOrderType());

        // 添加订单下的商品评价信息
        List<AddProductEvaluationReqDto> addProductEvaluationList = reqVo.getProductEvaluationList();
        if (CollectionUtils.isNotEmpty(addProductEvaluationList)) {
            List<AddProductEvaluationDto> productEvaluationList = new ArrayList<>();
            for (AddProductEvaluationReqDto addProductEvaluationReqDto : addProductEvaluationList) {
                AddProductEvaluationDto addProductEvaluationDto = this.convent2InsertProductEvaluationReqDto(reqVo, addProductEvaluationReqDto);
                productEvaluationList.add(addProductEvaluationDto);
            }
            request.setProductEvaluationList(productEvaluationList);
        }

        return request;
    }

    private Integer getDefaultValue(Integer value) {
        if (value == null) {
            return 5;
        }
        return value;
    }

    public AddProductEvaluationDto convent2InsertProductEvaluationReqDto(AddUserOrderEvaluationNewRequestVo reqVo, AddProductEvaluationReqDto addProductEvaluationReqDto) {
        AddProductEvaluationDto request = new AddProductEvaluationDto();
        request.setIsCall(addProductEvaluationReqDto.getIsCall() == null ? 0 : addProductEvaluationReqDto.getIsCall());
        request.setOrderId(reqVo.getOrderId());
        request.setPartnerId(reqVo.getPartnerId());
        request.setProductId(addProductEvaluationReqDto.getProductId());
        request.setProductName(addProductEvaluationReqDto.getProductName());
        request.setProductQty(addProductEvaluationReqDto.getProductQty());
        return request;
    }
}
