/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: PaySuccessTimeoutEnum
 * @Package com.freemud.sdk.api.assortment.order.enums
 * @Description:
 * @author: ping.wu
 * @date: 2019/11/8 18:39
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.sdk.api.assortment.order.enums;

public enum  PaySuccessTimeoutEnum {

    Timeout_1("1", 0),
    Timeout_2("2", 1),
    Timeout_3("3", 5);

    //超时类型
    private String code;
    //对应的分钟
    private Integer min;

    PaySuccessTimeoutEnum(String code, Integer min) {
        this.code = code;
        this.min = min;
    }

    public static Integer getMin(String code) {
        if (code == null) {
            return 0;
        }
        for (PaySuccessTimeoutEnum timeoutEnum : values()) {
            if (timeoutEnum.getCode().equals(code)) {
                return timeoutEnum.getMin();
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getMin() {
        return min;
    }

    public void setMin(Integer min) {
        this.min = min;
    }
}
