package com.freemud.sdk.api.assortment.shoppingcart.constant;

public enum CollageLockStatus {
    LOCKED(true, "已锁定"),
    RELEASE(false, "未锁定");

    private Boolean value;

    private String desc;

    CollageLockStatus(Boolean value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static CollageLockStatus getByValue(Object value) {
        try {
            return Boolean.parseBoolean(String.valueOf(value)) ? CollageLockStatus.LOCKED : CollageLockStatus.RELEASE;
        } catch (ClassCastException e) {
            return CollageLockStatus.RELEASE;
        }
    }

    public Boolean getValue() {
        return value;
    }

    public void setValue(Boolean value) {
        this.value = value;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
