package cn.freemud.management.controller;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import cn.freemud.management.entities.dto.response.pay.PayRefundResponse;
import cn.freemud.management.enums.ResponseResult;
import cn.freemud.management.service.OrderBaseService;
import cn.freemud.management.service.handle.PaymentHandle;
import cn.freemud.management.util.ResponseUtil;
import com.freemud.application.sdk.api.log.LogParams;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: UtilController
 * @Package cn.freemud.management.controller
 * @Description:
 * @author: ping1.wu
 * @date: 2020/10/7 11:41
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RequestMapping("/order")
@RestController
@Validated
public class UtilController {

    @Autowired
    private OrderBaseService orderBaseService;
    @Resource
    private PaymentHandle paymentHandle;

    @GetMapping("/refund/util")
    public BaseResponse deliveryCreate(@RequestParam("orderCode") String orderCode) {

        //查询订单
        QueryOrdersResponse.DataBean.OrderBean orderBean = orderBaseService.getByOrderCode(orderCode);
        //支付退款
        PayRefundResponse refund = paymentHandle.refund(null, orderBean);

        return ResponseUtil.success(refund);
    }

}
