package cn.freemud.service.mccafe.impl;

import cn.freemud.adapter.CouponAdapter;
import cn.freemud.adapter.OrderAdapter;
import cn.freemud.base.constant.Version;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.base.log.LogTreadLocal;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.entities.dto.QueryOrdersResponseDto;
import cn.freemud.enums.ResponseResult;
import cn.freemud.management.entities.dto.request.order.*;
import cn.freemud.enums.CouponReqTypeEnum;
import cn.freemud.enums.MCCafeChannelEnum;
import cn.freemud.management.entities.dto.response.coupon.McdNetBatchQueryResponse;
import cn.freemud.management.entities.dto.response.coupon.McdNetCouponInfoRespDto;
import cn.freemud.management.entities.dto.response.coupon.McdNetCouponProductRespDto;
import cn.freemud.management.enums.OrderSource;
import cn.freemud.management.thirdparty.CouponOfflineMCCafeClient;
import cn.freemud.service.mccafe.CouponClientService;
import cn.freemud.utils.LogUtil;
import cn.freemud.utils.ResponseUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponBaseResponse;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponQueryResponse;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponRedeemResponse;
import com.freemud.application.sdk.api.couponcenter.offline.service.OfflineCouponSdkService;
import com.freemud.application.sdk.api.log.ErrorLog;
import com.freemud.application.sdk.api.ordercenter.enums.OrderClientType;
import com.freemud.application.sdk.api.productcenter.response.menu.GetMenuCategoryByIdsResponse;
import com.freemud.application.sdk.api.service.EmailAlertService;
import com.freemud.sdk.api.assortment.order.enums.*;
import com.freemud.sdk.api.assortment.order.request.order.CreateOrderAccountRequest;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import com.google.common.base.Throwables;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
public class CouponClientServiceImpl implements CouponClientService {

    @Autowired
    private CouponOfflineMCCafeClient couponOfflineMCCafeClient;

    @Autowired
    private CouponAdapter couponAdapter;

    @Autowired
    private OrderAdapter orderAdapter;

    @Autowired
    private OfflineCouponSdkService offlineCouponSdkService;

    @Autowired
    private EmailAlertService emailAlertService;

    @Override
    public CouponRedeemResponse redeem(MCCafeCouponRequest mcCafeCouponRequest) {
        return couponOfflineMCCafeClient.redeem(mcCafeCouponRequest);
    }

    @Override
    public List<CouponRedeemResponse> redeemBatch(QueryOrdersResponseDto.DataBean.OrderBean orderBean) {
        if (null == orderBean || CollectionUtils.isEmpty(orderBean.getAccountList())) {
            return null;
        }
        List<QueryOrdersResponseDto.DataBean.OrderBean.AccountBean> accountList = orderBean.getAccountList().stream().filter(
                account -> (orderAdapter.getQueryOrderAccountType(OldOrderAccountType.getByCode(account.getType())).equals(QueryOrderAccountType.COUPON)
                        ||  orderAdapter.getQueryOrderAccountType(OldOrderAccountType.getByCode(account.getType())).equals(QueryOrderAccountType.PRODUCT_COUPON)
                        ||  orderAdapter.getQueryOrderAccountType(OldOrderAccountType.getByCode(account.getType())).equals(QueryOrderAccountType.DISCOUNT_COUPON)
                        ||  orderAdapter.getQueryOrderAccountType(OldOrderAccountType.getByCode(account.getType())).equals(QueryOrderAccountType.FREIGHT_COUPON))
                        ).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(accountList)) {
            return null;
        }

        MCCafeCouponRequest mcCafeCouponRequest = MCCafeCouponRequest.builder()
                .ver(88)
                .reqtype(CouponReqTypeEnum.BATCH_QUERY.getCode())
                .partnerId(Integer.parseInt(orderBean.getCompanyId()))
                .store_id(orderBean.getShopId())
                .station_id("1")
                .operator_id(orderBean.getUserId())
                .channel(OrderSource.ALIPAY.getSource().equals(orderBean.getSource())?MCCafeChannelEnum.MOCOFFEE_ZFB.getName():MCCafeChannelEnum.MOCOFFEE_WX.getName())
                .couponlist(accountList.stream().map(o -> new MCCafeCouponVo(o.getAccountId())).collect(Collectors.toList()))
                .sign("skip")
                .build();
        McdNetBatchQueryResponse mcdNetBatchQueryResponse = batchQuery(mcCafeCouponRequest);
        if (mcdNetBatchQueryResponse == null || !ResponseCodeConstant.RESPONSE_SUCCESS.equals(mcdNetBatchQueryResponse.getStatusCode())
                || CollectionUtils.isEmpty(mcdNetBatchQueryResponse.getCouponlist())) {
            LogUtil.error("获取优惠券详情失败，无法核销", mcCafeCouponRequest, mcdNetBatchQueryResponse);
            return null;
        }

        Map<String, McdNetBatchQueryResponse.Coupon> couponMap = mcdNetBatchQueryResponse.getCouponlist().stream()
                .collect(Collectors.toMap(McdNetBatchQueryResponse.Coupon::getCode, Function.identity(), (k1, k2) -> k1));

        List<MCCafeCouponRequest> list =
                accountList.stream().map(accountBean -> couponAdapter.convert2MCCafeCouponRequest(orderBean, accountBean, couponMap.get(accountBean.getAccountId()))).filter(o -> o!=null).collect(Collectors.toList());

        List<CouponRedeemResponse> couponRedeemResponseList = new ArrayList<>();
        List<CouponRedeemResponse> couponRedeemResponseListAll = new ArrayList<>();
        redeem:
        for (MCCafeCouponRequest request : list) {
            CouponRedeemResponse couponRedeemResponse = null;
            retry:
            for(int i=0;i<3;i++) {
                couponRedeemResponse = redeem(request);
                if(ResponseCodeConstant.RESPONSE_SUCCESS.equals(couponRedeemResponse.getStatusCode())) {
                    couponRedeemResponseListAll.add(couponRedeemResponse);
                    continue redeem;
                }
            }
            couponRedeemResponseList.add(couponRedeemResponse);
            couponRedeemResponseListAll.add(couponRedeemResponse);
        }
        if(CollectionUtils.isNotEmpty(couponRedeemResponseList)) {
            LogUtil.info(LogTreadLocal.getTrackingNo(), "麦咖啡核销券失败",
                    JSON.toJSONString(list), JSON.toJSONString(couponRedeemResponseListAll));
        }

        return couponRedeemResponseList;
    }
    @Override
    public McdNetBatchQueryResponse batchQuery(MCCafeCouponRequest mcCafeCouponRequest) {
        return couponOfflineMCCafeClient.batchQuery(mcCafeCouponRequest);
    }

    @Override
    public CouponBaseResponse lock(MCCafeCouponLockRequest mcCafeCouponLockRequest) {
        return couponOfflineMCCafeClient.lock(mcCafeCouponLockRequest);
    }

    @Override
    public List<CouponBaseResponse> lockBatch(QueryOrdersResponseDto.DataBean.OrderBean orderBean) {
        if (null == orderBean || CollectionUtils.isEmpty(orderBean.getAccountList())) {
            return null;
        }
        List<QueryOrdersResponseDto.DataBean.OrderBean.AccountBean> accountList = orderBean.getAccountList().stream().filter(
                account -> (orderAdapter.getQueryOrderAccountType(OldOrderAccountType.getByCode(account.getType())).equals(QueryOrderAccountType.COUPON)
                        ||  orderAdapter.getQueryOrderAccountType(OldOrderAccountType.getByCode(account.getType())).equals(QueryOrderAccountType.PRODUCT_COUPON)
                        ||  orderAdapter.getQueryOrderAccountType(OldOrderAccountType.getByCode(account.getType())).equals(QueryOrderAccountType.DISCOUNT_COUPON))
        ).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(accountList)) {
            return null;
        }

        List<MCCafeCouponLockRequest> list =
                accountList.stream().map(accountBean -> couponAdapter.convert2MCCafeCouponLockRequest(orderBean, accountBean)).collect(Collectors.toList());

        List<CouponBaseResponse> baseResponseList = new ArrayList<>();
        List<CouponBaseResponse> baseResponseListAll = new ArrayList<>();
        lock:
        for (MCCafeCouponLockRequest request : list) {
            CouponBaseResponse baseResponse = null;
            retry:
            for(int i=0;i<3;i++) {
                baseResponse = lock(request);
                if(ResponseCodeConstant.RESPONSE_SUCCESS.equals(baseResponse.getStatusCode())) {
                    baseResponseListAll.add(baseResponse);
                    continue lock;
                }
            }
            baseResponseList.add(baseResponse);
            baseResponseListAll.add(baseResponse);
        }

        if(CollectionUtils.isNotEmpty(baseResponseList)) {
            LogUtil.info(LogTreadLocal.getTrackingNo(), "麦咖啡冻结券失败",
                    JSON.toJSONString(list), JSON.toJSONString(baseResponseListAll));
        }

        return baseResponseList;
    }
}
