/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: liming.guo
 * @date: 2018/8/10 16:06
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.thirdparty;

import cn.freemud.entities.dto.*;
import cn.freemud.service.impl.mcoffee.entity.CouponAvailableReq;
import cn.freemud.service.impl.mcoffee.entity.CouponAvailableResp;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

// 测试http://115.159.65.101:8002  线上http://10.51.0.37:8002
@FeignClient(name = "COUPON",url="${saas.couponadapterclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CouponClient {

    /**
     * 领取优惠券
     */
    @PostMapping("/coupon/create")
    CouponBaseResponseDto create(CouponCreateDto couponCreateDto);

    /**
     * 查询用户优惠券列表
     */
    @PostMapping("/coupon/list")
    CouponListResponseDto list(CouponListDto couponListDto);

    /**
     * 优惠券核销
     */
    @Deprecated
    @PostMapping("/coupon/verification")
    CouponBaseResponseDto verification(CouponVerificationDto couponVerificationDto);

    /**
     * 核销验证接口
     */
    @PostMapping("/check/user/coupon")
    CouponBaseResponseDto verifyCheck(VerifyCheckRequestDto verifyCheckRequestDto);

    /**
     * 核销成功通知接口
     */
    @PostMapping("/coupon/verification/notice")
    CouponBaseResponseDto verifyNotice(VerifyNoticeRequestDto verifyNoticeRequestDto);

    /**
     * 麦咖啡校验券是否可用
     */
    @PostMapping("/mccafe/getCouponsAvailable")
    CouponAvailableResp getCouponsAvailable(CouponAvailableReq req);


}
