/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: MQTest
 * @Package cn.freemud.service
 * @Description:
 * @author: ping.wu
 * @date: 2019/7/4 17:13
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service;

import cn.freemud.entities.dto.OrderPrintDto;
import cn.freemud.service.impl.OrderServiceImpl;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.ArrayList;
import java.util.List;

@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class MQTest {

    @Autowired
    private OrderServiceImpl orderService;

    @Test
    public void test(){
        OrderPrintDto request =new OrderPrintDto();

        request.setPartnerId("1864");
        request.setStoreId("2019060403");
        request.setDaySeq("16");
        request.setType(5);
        request.setOid("14846754793783480100005");
        request.setUserName("Griggles");
        request.setPhone("16602109227");
        request.setAddress("沪宜公路1030弄2号");
        request.setGmtExpect("立即送出");
        request.setDeliveryTypeDesc("自配送");
        request.setRemark("");
        request.setProductTotalAmount(1);
        request.setProductAmount(1L);
        request.setPackageFee(0L);
        request.setSendFee(0L);
        request.setDiscountFee(0L);
        request.setUserFee(1L);
        request.setGmtCreate("2019-06-27 18:28:07");
        request.setShopName("$wangxianfeng");
        request.setOtherCode("3588");

        List<OrderPrintDto.ProductsBean> products = new ArrayList<>();
        OrderPrintDto.ProductsBean product = new OrderPrintDto.ProductsBean();
        product.setProductName("羊肉卷");
        product.setProductOtherInfo("大份");
        product.setPrice(1L);
        product.setNumber(1);
        products.add(product);

        request.setProducts(products);
        for (int i = 0;i<3;i++){
            orderService.asynchronousPrint(request);
        }
    }
}
