package cn.freemud.enums;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.6.0
 * @Title: RedisCacheEnum
 * @Description: 简单描述下这个类是做什么用的
 * @author: qin.zhou
 * @date: 2019/9/221:35
 * @Copyright: ${DATE.YARE} www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public enum  RedisCacheEnum {

    TABLENUMBER_ORDERCODE("kgd:encircle:tablenumber:orderId:","记录预支付订单桌号与订单号绑定关系"),
    /**
     * 围餐开台lock key   拼接商户:门店:桌号
     */
    CREATERESERVEORDER_LOCKKEY_PREFIX("kgd:encircle:order:begin:table:lock:","围餐开台业务lockKey"),
    TABLENUMBER_LOCKKEY_PREFIX("kgd:encircle:order:tablenumber:lock:","围餐业务开台后不完全依赖门店的桌号状态"),
    CREATE_PRE_PAYMENTORDER_LOCKKEY_PREFIX("kgd:encircle:pre:payment:table:lock:","围餐创建预支付业务lockKey"),
    ORDER_PLUS_DISH_LOCKKEY_PREFIX("kgd:encircle:plus:dish:table:lock:","围餐下单业务LockKey"),
    ORDER_CREATE_TRANS_ID_KEY("kgd:meal:trans:{0}:{1}:{2}:{3}","围餐下单多次创建预支付生成不同TRANS_ID"),
    ORDER_CREATE_PRE_PARMENT_INTO_LOCK("kgd:meal:pre:payment:lock:","围餐订单唤起预支付锁定不可下单"),
    ORDER_CACHE_WEICAN_TRANSID_INFO("kgd:meal:payment:trans:order:","缓存围餐支付transId"),
    PAYMENT_TRANSID_SEQUENCE_KEY("kgd:payment:transid:sequence:{1}", "创建预支付交易号序列"),
    PAYMENT_TRANSID_ORDER_KEY("kgd:payment:transid:order:{1}", "交易订单key"),
    ;


    private String code;

    private String desc;

    RedisCacheEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static RedisCacheEnum getByCode(String code) {
        for (RedisCacheEnum status : values()) {
            if (status.getCode().equals(code)) {
                return status;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
