package cn.freemud.enums;

public enum ActivityErrorCode {

    NORMAL(1, "正常"),
    EXPIRE(2, "活动已结束"),
    DAY_USED(3, "当天领取次数用完"),
    BROUGHT_OUT(4, "优惠券被抢光了"),
    COUPON_JOINED(5,"该优惠券限领次数已用完")
    ;

    private Integer code;
    private String desc;

    ActivityErrorCode(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ActivityErrorCode getByCode(Integer code) {
        for (ActivityErrorCode payType : values()) {
            if (payType.getCode().equals(code)) {
                return payType;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
