/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: DeliveryInfoModifyReq
 * @Package com.freemud.application.sdk.api.ordercenter.request
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/4 11:03
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.application.sdk.api.ordercenter.request;

import com.freemud.application.sdk.api.ordercenter.request.create.OrderTaskReq;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class OrderExpressReq {

    //订单编号
    private String orderCode;

    //第三方订单号
    private String thirdOrderCode;

    //    @ApiModelProperty(value = OrderClientType.API_DESC)
    private Byte orderClient;

    //配送渠道名称
    private String expressChannelName;

    //配送渠道编号
    private String expressChannelCode;

    //快递单号
    private String expressNo;

    //配送中台运单号
    private String thirdDeliveryId;

    //配送员姓名
    private String contactsName;

    //配送员手机
    private String mobile;

    //新订单状态
    private Integer orderSubState;

    //状态变更明细
    public String remark;

    //操作人
    private String operator;

    /**
     * 配送平台统一异常Id
     */
    private Integer exceptionId;
    /**
     * 配送平台统一异常描述
     */
    private String exceptionDesc;

    /**
     * 操作类型 0 = 发货 1=更改物流信息
     */
    private int opType;

    /**
     * 定时任务
     */
    private OrderTaskReq orderTaskReq;

    /**
     * 自动确认收货时间
     */
    private String autoReceiveTime;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 分配骑手时,三方平台的一个预估送达时间
     */
    public Long estimateArriveTime;

    /**
     * 商家承担的配送费(单位:分)
     */
    public BigDecimal businessDeliveryAmount;


}
