package com.freemud.application.sdk.api.ordercenter.enums;

import org.apache.commons.lang.StringUtils;

public enum OperateType {

    ORDER_CONFIRM("orderConfirm","接单"),
    ORDER_REJECT("orderReject","拒单"),
    ORDER_DONE("orderDone","制作完成"),
    ORDER_SEND("orderSend","送出"),
    ORDER_AFFIRM("orderAffirm","完成"),
    ORDER_AGREE_REFUND("orderAgreeRefund","同意退款"),
    ORDER_REJECT_REFUND("orderRejectRefund","拒绝退款"),
    ORDER_CANCEL("orderCancel","订单取消"),
    ORDER_SWITCH_SELF_DELIVERY("orderSwitchSelfDelivery","切换自配送");


    /**
     * 操作类型
     */
    private String opType;
    /**
     * 操作名称
     */
    private String opName;

    OperateType(String opType, String opName) {
        this.opType = opType;
        this.opName = opName;
    }

    public String getOpType() {
        return opType;
    }

    public void setOpType(String opType) {
        this.opType = opType;
    }

    public String getOpName() {
        return opName;
    }

    public void setOpName(String opName) {
        this.opName = opName;
    }

    public static OperateType getByOpType(String opType){
        if (StringUtils.isEmpty(opType)) {
            return null;
        }
        for (OperateType operateType : values()) {
            if (operateType.getOpType().equals(opType)) {
                return operateType;
            }
        }
        return null;

    }
}
