package cn.freemud.service.impl;

import cn.freemud.entities.dto.UserLoginInfoDto;
import cn.freemud.entities.dto.activity.ActivityQueryDto;
import cn.freemud.entities.dto.calculate.ActivityCalculationDiscountResponseDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.ActivityTypeEnum;
import cn.freemud.service.IPromotionService;
import com.google.common.collect.Lists;
import lombok.Data;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: null.java
 * @Package
 * @Description: (用一句话描述该文件做什么)
 * @author: 蓝胖子(Hector)
 * @date: 2019-11-14
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */

@Service("twoNDiscountService")
public class TwoNDiscountServiceImpl implements IPromotionService {
    @Override
    public void updateShoppingCartGoodsDiscount(CouponPromotionVO couponPromotionVO, ActivityQueryDto activityQueryDto, ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscountResult, List<CartGoods> cartGoodsList, ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo, UserLoginInfoDto userLoginInfoDto, ShoppingCartInfoRequestVo shoppingCartInfoRequestVo) {
        List<ApportionGoodsDetail> apportionGoodsDetailList = getApportionGoodsDetail(calculationDiscountResult);
        if (!CollectionUtils.isEmpty(apportionGoodsDetailList)) {
            if (apportionGoodsDetailList.stream().filter(goodsDetail -> StringUtils.isBlank(goodsDetail.getCartGoodsUid())).collect(Collectors.toList()).isEmpty()) {
                // 若促销返回优惠信息均包含购物车行ID，则按行ID进行优惠均摊
                List<String> cartGoodsUidList = apportionGoodsDetailList.stream().map(ApportionGoodsDetail::getCartGoodsUid).collect(Collectors.toList());
                List<CartGoods> list = cartGoodsList.stream().filter(cartGoods -> cartGoodsUidList.contains(cartGoods.getCartGoodsUid())).collect(Collectors.toList());
                Map<String, ApportionGoodsDetail> map = apportionGoodsDetailList.stream().collect(Collectors.toMap(ApportionGoodsDetail::getCartGoodsUid, detail -> detail));
                Map<String, Long> mapPro = apportionGoodsDetailList.stream().collect(Collectors.toMap(ApportionGoodsDetail::getCartGoodsUid, detail -> detail.getActivityApportionAmount()));
                if (!CollectionUtils.isEmpty(list)) {
                    for (CartGoods cartGoods : list) {
                        if (mapPro.get(cartGoods.getCartGoodsUid()) > 0) {
                            cartGoods.setAmount(cartGoods.getAmount() - map.get(cartGoods.getCartGoodsUid()).getActivityApportionAmount());
                            mapPro.put(cartGoods.getCartGoodsUid(), mapPro.get(cartGoods.getCartGoodsUid()) - map.get(cartGoods.getCartGoodsUid()).getActivityApportionAmount());
                        }
                    }
                }
            } else {
                // 原算价逻辑，根据购物车商品ID进行优惠均摊
                List<String> goodIdsList = apportionGoodsDetailList.stream().map(ApportionGoodsDetail::getGoodsId).collect(Collectors.toList());
                List<CartGoods> list = cartGoodsList.stream().filter(cartGoods -> goodIdsList.contains(cartGoods.getGoodsId())).collect(Collectors.toList());
                Map<String, ApportionGoodsDetail> map = apportionGoodsDetailList.stream().collect(Collectors.toMap(ApportionGoodsDetail::getGoodsId, detail -> detail));
                Map<String, Long> mapPro = apportionGoodsDetailList.stream().collect(Collectors.toMap(ApportionGoodsDetail::getGoodsId, detail -> detail.getActivityApportionAmount()));
                if (!CollectionUtils.isEmpty(list)) {
                    for (CartGoods cartGoods : list) {
                        if (mapPro.get(cartGoods.getGoodsId()) > 0) {
                            cartGoods.setAmount(cartGoods.getAmount() - map.get(cartGoods.getGoodsId()).getActivityApportionAmount());
                            mapPro.put(cartGoods.getGoodsId(), mapPro.get(cartGoods.getGoodsId()) - map.get(cartGoods.getGoodsId()).getActivityApportionAmount());
                        }
                    }
                }
            }
        }
    }

    @Override
    public void updateShoppingCartGoodsApportion(ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo, ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscountResult, ShoppingCartGoodsDto shoppingCartGoodsDto, CreateOrderVo.PremiumExchangeActivity premiumExchangeActivity, ShoppingCartInfoRequestVo shoppingCartInfoRequestVo) {

    }

    private List<ApportionGoodsDetail> getApportionGoodsDetail(ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscountResult) {
        // 遍历购物车内的商品，如果存在则进行均摊
        if (calculationDiscountResult == null || CollectionUtils.isEmpty(calculationDiscountResult.getApportionGoods())) {
            return null;
        }
        List<ApportionGoodsDetail> list = Lists.newArrayList();
        for (ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods apportionGood : calculationDiscountResult.getApportionGoods()) {
            if (!CollectionUtils.isEmpty(apportionGood.getApportionDetails())) {
                for (ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ApportionGoods.ApportionDetails apportionDetail : apportionGood.getApportionDetails()) {
                    if (apportionDetail.getActivityType().equals(ActivityTypeEnum.TYPE_53.getCode())) {
                        ApportionGoodsDetail apportionGoodsDetail = new ApportionGoodsDetail();
                        apportionGoodsDetail.setActivityApportionAmount(apportionDetail.getActivityApportionAmount());
                        apportionGoodsDetail.setActivityCode(apportionDetail.getActivityCode());
                        apportionGoodsDetail.setActivityName(apportionDetail.getActivityName());
                        apportionGoodsDetail.setGoodsId(apportionGood.getGoodsId());
                        apportionGoodsDetail.setCartGoodsUid(apportionGood.getCartGoodsUid());
                        list.add(apportionGoodsDetail);
                    }
                }
            }
        }
        return list;
    }


    @Data
    private class ApportionGoodsDetail {
        /**
         * 活动code,如果是商品券，优惠券，放券code
         */
        private String activityCode;
        /**
         * 活动名称，如果是商品券，优惠券，放券名称
         */
        private String activityName;
        /**
         * 活动均摊金额
         */
        private Long activityApportionAmount;
        private String goodsId;
        /**
         * 购物车行记录
         */
        private String cartGoodsUid;
    }
}
