package cn.freemud.entities.bo;

import cn.freemud.entities.dto.order.CreateOrderOperateDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.CreateOrderBaseVo;
import cn.freemud.entities.vo.GetProductsVo;
import cn.freemud.enums.CreateOrderSceneEnum;
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo;
import com.freemud.application.sdk.api.membercenter.response.GetSvcInfoByMemberIdResponse;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtInfoDto;
import com.freemud.application.sdk.api.ordercenter.request.create.CreateOrderRequest;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import com.freemud.sdk.api.assortment.order.request.order.BaseCreateOrderRequest;
import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class CreateOrderBo {

    //创单业务场景
    CreateOrderSceneEnum createOrderScene;

    private CreateOrderBaseVo createOrderBaseVo;

    private AssortmentCustomerInfoVo userLoginInfoDto;

    private ShoppingCartGoodsDto shoppingCartGoodsDto;

    private StoreResponse.BizVO storeResponseDto;

    private OrderExtInfoDto extInfo;

    private List<GetSvcInfoByMemberIdResponse> svcInfoList;

    private CreateOrderOperateDto createOrderOperateDto;

    private CreateOrderRequest createOrderRequest;

    private Map<String, GetProductsVo> products;

    /**
     *  商城转换后的对象, 在减库存中要使用
     */
    private BaseCreateOrderRequest baseCreateOrderRequest;
}
