package com.freemud.sdk.api.assortment.shoppingcart.enums;


/**
 * @author wanghanghang
 * @title: QueryHeardServiceImpl
 * @projectName order_group
 * @description: 订单BizType枚举类
 * @date 2021/7/15下午10:50
 */
public enum BizTypeEnum {

    //字段6代表卖券订单。
    //蜜雪APP和平台通用。
    //后续使用此字段需注意。名称APP_COUPON取得有些误导，由于有地方使用，暂时不更改
    APP_COUPON(6, "卖券订单"),
    ORDINARY(1, "普通订单"),
    VIRTUAL(2, "虚拟订单"),
    MEMBERS(3, "会员订单"),
    INTEGRAL_MALL(4, "积分商城订单"),
    SVC(5, "储值卡订单"),
    SALE_COUPON(6, "卖券订单"),
    /**
     *  增对 爱马哥的蛋糕预定出的需求,
     */
    ADVANCE_ORDER(7, "预订单"),
    LGS_SELF_HELP_PARKING(97, "农工商停车自助积分订单"),
    LGS_MANUAL_RECORD_PARKING(98, "农工商停车手工录单"),
    LGS_PARKING(99, "农工商停车订单");


    private Integer bizType;
    private String desc;

    BizTypeEnum(Integer bizType, String desc) {
        this.bizType = bizType;
        this.desc = desc;
    }

    public static BizTypeEnum getByCode(Integer code) {
        for (BizTypeEnum bizTypeEnum : values()) {
            if (bizTypeEnum.getBizType().equals(code)) {
                return bizTypeEnum;
            }
        }
        return null;
    }

    public Integer getBizType() {
        return bizType;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}