package cn.freemud.service;

import cn.freemud.ShoppingCartApplication;
import cn.freemud.entities.dto.CheckSpqInfoRequestDto;
import cn.freemud.entities.dto.CheckSpqInfoResponseDto;
import cn.freemud.entities.dto.GetCouponDetailResponseDto;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountResponseDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.CartGoods;
import cn.freemud.entities.vo.GetMemberCouponRequestVo;
import cn.freemud.entities.vo.ShoppingCartGoodsResponseVo;
import cn.freemud.service.impl.calculate.CalculationCommonService;
import cn.freemud.service.impl.calculate.promotion.FullSharingService;
import cn.freemud.utils.FileUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.freemud.card.sdk.comm.Finals;
import com.freemud.card.sdk.comm.SignUtil;
import com.freemud.card.sdk.service.*;
import com.freemud.card.sdk.util.DateUtil;
import com.freemud.card.sdk.vo.comm.GetCodeRespVo;
import com.freemud.card.sdk.vo.comm.GetCouponVo;
import com.freemud.card.sdk.vo.coupon.CouponVo;
import com.freemud.card.sdk.vo.coupon.MemberCouponVo;
import com.freemud.card.sdk.vo.coupon.request.ActiveInsertRequest;
import com.freemud.card.sdk.vo.coupon.request.MemberCardVo;
import com.freemud.card.sdk.vo.coupon.request.PromotionUserCouponReqVo;
import com.freemud.card.sdk.vo.coupon.response.ActiveInsertRespVo;
import com.freemud.card.sdk.vo.coupon.response.MemberCouponRespVo;
import com.freemud.card.sdk.vo.coupon.response.PromotionBaseRespVo;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title:
 * @Package: com.freemud.card.sdk
 * @Description:
 * @author: genyou.cui
 * @date: 2018/12/17 16:34
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes = ShoppingCartApplication.class)
public class CouponTest {

    private static final Logger logger = LoggerFactory.getLogger(CouponTest.class);
    @Autowired
    private FMCouponService fmCouponService;
    @Autowired
    private FMActiveService fmActiveService;
    @Autowired
    private GetCouponService getCouponService;
    @Autowired
    private MemberProductService memberProductService;
    @Autowired
    private PromotionService promotionService;
    @Autowired
    private RedeemCouponService redeemCouponService;
    @Autowired
    private CouponService couponService;
    @Autowired
    private CalculationCommonService calculationCommonService;
    @Autowired
    private FullSharingService fullSharingService;

    @Test
    public void testGetCoupon() {
        String fileName = "getCoupons";
        GetCouponVo getCouponVo = FileUtil.getObjectFromFile(fileName, GetCouponVo.class);
        GetCodeRespVo codeRespVo = getCouponService.getCoupons(getCouponVo);
        logger.info(JSONObject.toJSONString(codeRespVo));

    }

    @Test
    public void couponCreate() {
        String partnerId = "1864";
        MultiValueMap<String, String> couponOnlineMap = new LinkedMultiValueMap<>();
        couponOnlineMap.add(Finals.PARTNER_ID, partnerId);
        couponOnlineMap.add(Finals.MERCHANT_ID, partnerId);
        couponOnlineMap.add(Finals.ORDER_ID, "ISAASTest123456789");
        couponOnlineMap.add(Finals.ACTIVECODE, "C201811151617006zhvy");
        couponOnlineMap.add(Finals.VALID_ENDS, "2019-12-01 00:00:00");
        couponOnlineMap.add(Finals.VALID_START, "2018-12-01 00:00:00");
        String mobile = "15651101234";
        couponOnlineMap.add(Finals.MOBILE, mobile);

        couponOnlineMap.add(Finals.TITLE, "cyj可领5次券");
        couponOnlineMap.add(Finals.TIMESTAMP, DateUtil.getCurrentDate(DateUtil.FORMAT_YYYY_MM_DD_HHMMSS));
        couponOnlineMap.add(Finals.NUMBER, "1");
        couponOnlineMap.add(Finals.ACTION, "code.create");

        String appSecret = "C0CB6FCDE7C745F4AEE81A152F77B728";
        Map<String, String> signMap = couponOnlineMap.toSingleValueMap();
        String sign = SignUtil.createMD5Sign(signMap, appSecret);
        couponOnlineMap.add(Finals.SIGN, sign);

//        CouponCreateResponseVo code = fmCouponService.createCode(couponOnlineMap);
//        logger.info(JSONObject.toJSONString(code));
    }

    @Test
    public void promotionSaveUserCoupon() {
        String partnerId = "1864";
        String mobile = "15651101234";
        String activityCode = "MEHG2018121719200242839";
        String code = "88600017957001943687";
        PromotionUserCouponReqVo promotionUserCouponReqVo = new PromotionUserCouponReqVo();
        promotionUserCouponReqVo.setVer(1);
        promotionUserCouponReqVo.setPartnerCode(partnerId);
        promotionUserCouponReqVo.setUserId("115393308065249235");
        promotionUserCouponReqVo.setMobile(mobile);
        List<CouponVo> coupons = new ArrayList<>();
        CouponVo couponVo = new CouponVo();
        couponVo.setCouponCode(code);
        couponVo.setActivityCode(activityCode);
        String startDate = "2018-12-01 00:00:00";
        String endDate = "2019-12-01 00:00:00";
        couponVo.setValidityPeriodStart(DateUtil.convert2Date(startDate, DateUtil.FORMAT_YYYY_MM_DD_HHMMSS));
        couponVo.setValidityPeriodEnd(DateUtil.convert2Date(endDate, DateUtil.FORMAT_YYYY_MM_DD_HHMMSS));
        coupons.add(couponVo);
        promotionUserCouponReqVo.setCoupons(coupons);

        PromotionBaseRespVo promotionBaseRespVo = promotionService.saveUserCoupon(promotionUserCouponReqVo);
        logger.info(JSONObject.toJSONString(promotionBaseRespVo));
    }

    @Test
    public void getmembercoupon() {
        //1617,1617，88600017957134272219
        String partnerId = "1617";
        String memberId = "1617";
        String code = "88600017957134272219";
        MemberCardVo memberCardVo = new MemberCardVo();
        memberCardVo.setPartnerId(partnerId);
        memberCardVo.setMemberId(memberId);
        memberCardVo.setCouponCode(code);
        MemberCouponRespVo<MemberCouponVo> memberCoupon = memberProductService.getMemberCoupon(memberCardVo);
        logger.info(JSONObject.toJSONString(memberCoupon));
    }

    @Test
    public void getMemberCoupon() {
        //1617,1617，88600017957134272219
        String partnerId = "1864";
        String memberId = "1864";
        String code = "88600369801000970417";
        GetMemberCouponRequestVo requestVo=new GetMemberCouponRequestVo();
        requestVo.setCouponCode(code);
        requestVo.setPartnerId(partnerId);
        requestVo.setSessionId("8ecf77ce6af7d266fbbfc990b6e0918a1127e34a");
        GetCouponDetailResponseDto memberCoupon = couponService.getMemberCoupon(requestVo);
        logger.info(JSONObject.toJSONString(memberCoupon));
    }
    @Test
    public void checkSpqInfo() {
        //1617,1617，88600017957134272219
        String partnerId = "1864";
        String memberId = "1617";
        String code = "88600039947518452055";
        CheckSpqInfoRequestDto requestDto=new CheckSpqInfoRequestDto();
        requestDto.setCouponCode(code);
        requestDto.setPartnerId(partnerId);
        requestDto.setStoreId("111");
        CheckSpqInfoResponseDto memberCoupon = couponService.checkSpqInfo(requestDto);
        logger.info(JSONObject.toJSONString(memberCoupon));
    }

    @Test
    public void addCouponActive() {
        String req="{\n" +
                "    \"Active\": {\n" +
                "        \"EBCode\": \"0000000517\",\n" +
                "        \"Type\": 1,\n" +
                "        \"PartnerID\": 1864,\n" +
                "        \"PlatformItemId\": \"\",\n" +
                "        \"State\": 1,\n" +
                "        \"ActiveCode\": \"TS201812181845001\",\n" +
                "        \"ActiveName\": \"SDK代金券测试\",\n" +
                "        \"ActiveDesc\": \"SDK代金券测试\",\n" +
                "        \"CreateUser\": \"SDKadmin\",\n" +
                "        \"CreateDate\": \"2018-12-18T19:05:23\",\n" +
                "        \"LastEditUser\": \"SDKadmin\",\n" +
                "        \"LastEditDate\": \"2018-12-18T19:05:23\",\n" +
                "        \"StartDate\": \"2018-12-18T00:00:00\",\n" +
                "        \"EndDate\": \"2019-12-18T00:00:00\",\n" +
                "        \"ShouldRedeemAll\": 0,\n" +
                "        \"PromotionType\": \"AAA\",\n" +
                "        \"Exclusive\": null,\n" +
                "        \"MinAmount\": 1000,\n" +
                "        \"MaxRedeemTimes\": 1000,\n" +
                "        \"MaxSendOut\": 100,\n" +
                "        \"Cost\": 3.0,\n" +
                "        \"BusinessID\": 1\n" +
                "    },\n" +
                "    \"ActiveProduct\": [\n" +
                "        {\n" +
                "            \"ProductID_Partner\": \"1234567\",\n" +
                "            \"Product\": \"SDK3元代金券\",\n" +
                "            \"Price_Original\": 3,\n" +
                "            \"Price_Discount\": 3,\n" +
                "            \"Amount\": 1,\n" +
                "            \"Paid\": 3,\n" +
                "            \"Remain\": 0\n" +
                "        }\n" +
                "    ],\n" +
                "    \"ActiveRestrict\": [\n" +
                "        {\n" +
                "            \"City\": \"\",\n" +
                "            \"StoreIDPartner\": \"10086\"\n" +
                "        }\n" +
                "    ],\n" +
                "    \"ActiveProductSetting\": [\n" +
                "        {\n" +
                "            \"ProductCode\": \"01000009\",\n" +
                "            \"CategoryCode\": \"\",\n" +
                "            \"Type\": 0\n" +
                "        }\n" +
                "    ]\n" +
                "}";
        String appSecret = "C0CB6FCDE7C745F4AEE81A152F77B728";
        ActiveInsertRequest activeInsertRequest = JSONObject.parseObject(req, ActiveInsertRequest.class);
        activeInsertRequest.setAppSecret(appSecret);
        ActiveInsertRespVo activeInsertRespVo = fmActiveService.insertActive(activeInsertRequest);
        logger.info(JSONObject.toJSONString(activeInsertRespVo));
    }

    @Test
    public void cartTest() {
        ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo = new ShoppingCartGoodsResponseVo();
        /**
         * json string
         */
        String cartGoodsListStr = "[{\"spuName\":\"套餐lulu34\",\"originalPrice\":3830,\"goodsId\":\"177302125478533179\",\"productMaterialList\":[],\"customerCode\":\"55555552345789876543212345678909876543234567890987\",\"finalPrice\":500,\"createTimeMili\":1602306494889,\"pic\":\"https://picture.sandload.cn/1594880528035.jpg\",\"productComboList\":[{\"spuName\":\"单品lulu4\",\"originalPrice\":500,\"goodsId\":\"170060233309334535\",\"customerCode\":\"8765\",\"finalPrice\":500,\"pic\":\"https://picture.sandload.cn/1598261441993.jpg\",\"extra\":[{\"attributeId\":\"154178730067056650\",\"attributeName\":\"加水\"}],\"specProductId\":\"154178730067056650\",\"skuId\":\"170060233309334535\",\"amount\":500,\"weight\":5.18,\"tax\":0.01,\"weightType\":false,\"unit\":\"g\",\"originalAmount\":500,\"subName\":\"加水\",\"taxId\":\"\",\"qty\":1,\"name\":\"单品lulu4\"},{\"spuName\":\"单品lulu3\",\"originalPrice\":350,\"goodsId\":\"170060198366587966\",\"customerCode\":\"852852\",\"finalPrice\":350,\"pic\":\"https://img10.sandload.cn/zfx01.jpg?timestamp=1593832540030\",\"extra\":[{\"attributeId\":\"163358286692775186\",\"attributeName\":\"重麻\"},{\"attributeId\":\"163358360337413399\",\"attributeName\":\"重辣\"}],\"specProductId\":\"163358286692775186/163358360337413399\",\"skuId\":\"170060198366587966\",\"amount\":350,\"weight\":0.0,\"tax\":0.01,\"weightType\":false,\"unit\":\"g\",\"originalAmount\":350,\"subName\":\"重麻/重辣\",\"taxId\":\"\",\"qty\":1,\"name\":\"单品lulu3\"}],\"categoryName\":\"套餐\",\"originalMaterialAmount\":0,\"packPrice\":0,\"skuName\":\"套餐lulu34\",\"riseSell\":1,\"classificationName\":\"\",\"productGroupList\":[{\"spuName\":\"柚子的单品多属性\",\"originalPrice\":2980,\"goodsId\":\"161827301887133737\",\"productGroupId\":161989603366078508,\"customerCode\":\"4543543543\",\"finalPrice\":2980,\"pic\":\"https://img10.sandload.cn/zfx01.jpg?timestamp=1593832540030\",\"extra\":[{\"attributeId\":\"152211084882987801\",\"attributeName\":\"不加糖\"},{\"attributeId\":\"185339298173928979\",\"attributeName\":\"中快\"}],\"specProductId\":\"152211084882987801/185339298173928979\",\"skuId\":\"161827301887133737\",\"amount\":2980,\"weight\":0.0,\"tax\":0.01,\"weightType\":false,\"unit\":\"g\",\"originalAmount\":2980,\"subName\":\"不加糖/中快\",\"taxId\":\"\",\"qty\":1,\"name\":\"柚子的单品多属性\"}],\"memberDiscount\":100,\"skuId\":\"177302125478533179\",\"amount\":3830,\"cartGoodsUid\":\"e74a2fad-49c6-4f73-bd2f-adbdd905277c\",\"stockLimit\":false,\"weight\":0.01,\"tax\":0.01,\"classificationId\":\"\",\"goodsType\":3,\"weightType\":false,\"unit\":\"\",\"originalAmount\":3830,\"subName\":\"\",\"taxId\":\"\",\"qty\":1,\"name\":\"套餐lulu34\",\"materialAmount\":0,\"spuId\":\"177302125478533179\"}]";
        List<CartGoods> cartGoodsList = JSONObject.parseObject(cartGoodsListStr, new TypeReference<List<CartGoods>>() {
        });

        String discountResultStr = "{\"couponDiscounts\":[],\"originalTotalAmount\":3830,\"totalDiscountAmount\":1150,\"deliveryAmount\":0,\"distributionFee\":0,\"goods\":[{\"gift\":false,\"smallMaterial\":[{\"realAmount\":2294,\"discounts\":[{\"activityCode\":\"JTMJ2020092514310052470\",\"goodsId\":\"161827301887133737\",\"activityName\":\"丹妮满减\",\"actualGoodsNumber\":0,\"discount\":686,\"type\":12,\"activityDesc\":\"description\"}],\"originalPrice\":2980,\"goodsId\":\"161827301887133737\",\"discountAmount\":686,\"goodsQuantity\":1,\"type\":2}],\"groupCombox\":[{\"discounts\":[{\"activityCode\":\"TCYH0000000001\",\"goodsId\":\"170060233309334535\",\"activityName\":\"套餐活动优惠\",\"actualGoodsNumber\":0,\"discount\":206,\"type\":310,\"activityDesc\":\"套餐活动优惠\"},{\"goodsId\":\"170060233309334535\",\"activityName\":\"丹妮满减\",\"actualGoodsNumber\":0,\"discount\":67,\"type\":12}],\"originalPrice\":500,\"goodsId\":\"170060233309334535\",\"discountAmount\":273,\"goodsQuantity\":1},{\"discounts\":[{\"activityCode\":\"TCYH0000000001\",\"goodsId\":\"170060198366587966\",\"activityName\":\"套餐活动优惠\",\"actualGoodsNumber\":0,\"discount\":143,\"type\":310,\"activityDesc\":\"套餐活动优惠\"},{\"goodsId\":\"170060198366587966\",\"activityName\":\"丹妮满减\",\"actualGoodsNumber\":0,\"discount\":46,\"type\":12}],\"originalPrice\":350,\"goodsId\":\"170060198366587966\",\"discountAmount\":189,\"goodsQuantity\":1}],\"cartGoodsUid\":\"e74a2fad-49c6-4f73-bd2f-adbdd905277c\",\"originalPrice\":850,\"goodsId\":\"177302125478533179\",\"actualGoodsNumber\":1,\"discountAmount\":464,\"meal\":true,\"realAmount\":386,\"nowPrice\":500,\"discounts\":[{\"activityCode\":\"JTMJ2020092514310052470\",\"goodsId\":\"177302125478533179\",\"activityName\":\"丹妮满减\",\"actualGoodsNumber\":1,\"discount\":114,\"type\":12},{\"activityCode\":\"TCYH0000000001\",\"goodsId\":\"177302125478533179\",\"activityName\":\"套餐活动优惠\",\"actualGoodsNumber\":0,\"discount\":350,\"type\":310,\"activityDesc\":\"套餐活动优惠\"}],\"goodsQuantity\":1,\"cartGoodType\":0}],\"apportionGoods\":[],\"sendGoods\":[{\"activityCode\":\"MEHG2020092914160146595\",\"activityName\":\"丹妮加价购活动\",\"activityType\":81,\"maxNum\":3,\"sendGoods\":[{\"nowPrice\":100,\"originalPrice\":1300,\"goodsId\":\"186550397673068596\",\"sendNumber\":1,\"category\":\"186550397673068596\",\"goodsName\":\"桔子单品12\"},{\"nowPrice\":100,\"originalPrice\":1200,\"goodsId\":\"186550397637417010\",\"sendNumber\":1,\"category\":\"186550397637417010\",\"goodsName\":\"桔子单品11\"},{\"nowPrice\":100,\"originalPrice\":1100,\"goodsId\":\"186550397599668272\",\"sendNumber\":1,\"category\":\"186550397599668272\",\"goodsName\":\"桔子单品10\"}],\"minNum\":0}],\"stocks\":[{\"activityCode\":\"JTMJ2020092514310052470\",\"activityStock\":1,\"activityType\":12,\"goodsStock\":[]},{\"activityCode\":\"MEHG2020092914160146595\",\"activityType\":81,\"goodsStock\":[{\"goodsId\":\"186550397673068596\",\"stock\":1},{\"goodsId\":\"186550397637417010\",\"stock\":1},{\"goodsId\":\"186550397599668272\",\"stock\":1}]}],\"totalAmount\":2680,\"discounts\":[{\"activityCode\":\"JTMJ2020092514310052470\",\"thresholdAmount\":1000,\"activityName\":\"丹妮满减\",\"discount\":800,\"type\":12,\"activityDesc\":\"description\"},{\"activityCode\":\"MEHG2020092914160146595\",\"activityName\":\"丹妮加价购活动\",\"discount\":0,\"type\":81,\"activityDesc\":\"\"},{\"activityCode\":\"TCYH0000000001\",\"activityName\":\"套餐活动优惠\",\"discount\":350,\"type\":310,\"activityDesc\":\"套餐活动优惠\"}],\"validCouponMap\":{}}";
        CalculationSharingDiscountResponseDto.CalculationDiscountResult discountResult = JSONObject.parseObject(discountResultStr, new TypeReference<CalculationSharingDiscountResponseDto.CalculationDiscountResult>() {
        });
        /**
         * 用促销价格初始化购物车行记录成交价
         */
        calculationCommonService.initShoppingCart(discountResult, cartGoodsList, shoppingCartGoodsResponseVo);
        /**
         * 满减处理
         */
        //fullSharingService.fullResponse(discountResult, cartGoodsList, shoppingCartGoodsResponseVo, null);
        List<CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods> goods = discountResult.getGoods();
        /**
         * 利用促销赋值totalDiscountAmount
         */
        List<ShoppingCartGoodsDto.CartGoodsDetailDto> cartGoodsDetailDtoList = new ArrayList<>();
        shoppingCartGoodsResponseVo.setProducts(cartGoodsList);
        for (CartGoods product : shoppingCartGoodsResponseVo.getProducts()) {
            CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods find = goods.stream().filter((k) -> k.getCartGoodsUid().equals(product.getCartGoodsUid())).findFirst().get();
            ShoppingCartGoodsDto.CartGoodsDetailDto cartGoodsDetailDto = calculationCommonService.convertCartGoods2DetailGoodsList(find, product);
            cartGoodsDetailDtoList.add(cartGoodsDetailDto);
        }
    }

}
