/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderType
 * @Package cn.freemud.enums
 * @Description: 订单状态
 * @author: liming.guo
 * @date: 2018/5/21 14:43
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.enums;

import lombok.Getter;

@Getter
public enum TradeState {

    SUCCESS("SUCCESS","支付成功"),
    REFUND("REFUND","转入退款"),
    NOTPAY("NOTPAY","未支付"),
    CLOSED("CLOSED","已关闭"),
    REVOKED("REVOKED","已撤销（刷卡支付)"),
    USERPAYING("USERPAYING","用户支付中"),
    PAYERROR("PAYERROR","支付失败(其他原因，如银行返回失败)");

    private String code;
    private String desc;

    TradeState(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }


}
