package cn.freemud.service.impl.mcoffee.calculation;

import cn.freemud.entities.dto.calculate.ActivityCalculationDiscountResponseDto;
import cn.freemud.entities.vo.ActivityList;
import cn.freemud.entities.vo.ActivityTip;
import cn.freemud.entities.vo.ShoppingCartGoodsResponseVo;
import cn.freemud.enums.ActivityTypeEnum;
import cn.freemud.utils.MoneyUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class FreightCalculation {

    public void updateBuySendActivityTip(ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscountResult, ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo) {
        if(CollectionUtils.isNotEmpty(calculationDiscountResult.getActivityPrompts())) {
            List<ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ActivityPrompt> activityPromptList = calculationDiscountResult.getActivityPrompts().stream().filter(o -> ActivityTypeEnum.TYPE_14.getCode().equals(o.getActivityType())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(activityPromptList)) {
                ActivityCalculationDiscountResponseDto.CalculationDiscountResult.ActivityPrompt activityPrompt = activityPromptList.get(0);
                ActivityTip activityTip = shoppingCartGoodsResponseVo.getActivityTip();
                if (activityTip == null) {
                    activityTip = new ActivityTip();
                    shoppingCartGoodsResponseVo.setActivityTip(activityTip);
                }
                if (CollectionUtils.isEmpty(activityTip.getActivityList())) {
                    activityTip.setActivityList(new ArrayList<ActivityList>());
                }
                if(activityPrompt.getAlreadyDiscountAmount() == 0) {
                    return;
                }
                ActivityList activityList = new ActivityList();
                activityList.setTipType(activityPrompt.getActivityType());
                activityList.setSatisfy(MoneyUtils.parseFen2YuanInt(activityPrompt.getAlreadyDiscountThresholdAmount()));
                activityList.setAlreadyDecut(MoneyUtils.parseFen2YuanInt(activityPrompt.getAlreadyDiscountAmount()));
                activityList.setDeduct(MoneyUtils.parseFen2YuanInt(activityPrompt.getAlreadyDiscountAmount()));
                activityList.setAgianDeduct(MoneyUtils.parseFen2YuanInt(activityPrompt.getDiscountAmout() - activityPrompt.getAlreadyDiscountAmount()));
                if(activityPrompt.getThresholdAmount() > activityPrompt.getTotalAmount()) {
                    activityList.setMissing(MoneyUtils.parseFen2Yuan(activityPrompt.getThresholdAmount() - activityPrompt.getTotalAmount()));
                    activityList.setAgainBuy(MoneyUtils.parseFen2Yuan(activityPrompt.getThresholdAmount() - activityPrompt.getTotalAmount()));
                } else {
                    activityList.setMissing("0");
                    activityList.setAgainBuy("0");
                }
                activityTip.getActivityList().add(activityList);
            }
        }
    }
}