package cn.freemud.service.thirdparty;


//import cn.freemud.constant.IgnoreFeignLogAnnotation;
import cn.freemud.annotations.LogIgnoreFeign;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.dto.GetCouponDetailResponseDto;
import cn.freemud.entities.dto.coupon.InvalidCouponsRequestDto;
import cn.freemud.entities.dto.coupon.InvalidCouponsResponseDto;
import cn.freemud.interceptor.FormSupportConfig;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

//@IgnoreFeignLogAnnotation
@FeignClient(name = "OPEN-STORE-ONLINE-COUPON-SERVICE", url = "${saas.coupononlineclient.feign.url}", configuration = FormSupportConfig.class)
public interface CouponOnlineClient {


    // TODO: 21-4-1 待合并

    /**
     * 查询券详情
     */
    @PostMapping(value = "/code_v4", produces = MediaType.APPLICATION_JSON_UTF8_VALUE,
            consumes = {MediaType.APPLICATION_FORM_URLENCODED_VALUE}
    )
    @LogIgnoreFeign(logMessage="getCouponDetails",messageFieldName= ResponseCodeKeyConstant.MSG,statusCodeFieldName=ResponseCodeKeyConstant.STATUS_CODE)
    GetCouponDetailResponseDto getCouponDetails(@RequestParam Map<String, ?> map);

    /**
     * 查询券详情
     */
    @LogIgnoreFeign(logMessage="invalidCoupons",messageFieldName= ResponseCodeKeyConstant.MSG,statusCodeFieldName=ResponseCodeKeyConstant.STATUS_CODE)
    @PostMapping(value = "/coupon/state/invalid/coupons")
    InvalidCouponsResponseDto invalidCoupons(@RequestBody InvalidCouponsRequestDto invalidCouponsRequestDto);
}
