/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: StoreItemClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/16 9:39
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.thirdparty;

import cn.freemud.entities.dto.ShopBaseResponseDto;
import cn.freemud.entities.dto.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

@FeignClient(value = "PRODUCTSERVICE",url="${saas.storeitemclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface StoreItemClient {

    /**
     * 获取门店特定时间段菜单分类
     */
    @PostMapping(value = "/Menu/GetMenu")
    GetMenuResponseDto getMenuCategory(@RequestBody GetMenuCategoryInfoDto getMenuCategoryInfoDto);

    /**
     * 根据spu或单品ID查询菜单
     * 根据商品id查询门店特定时间段菜单
     */
    @PostMapping(value = "/Menu/GetMenuByIds")
    GetMenuByIdsResponseDto getMenuCategoryByIds(@RequestBody GetMenuCategoryByIdsDto getMenuCategoryByIdsDto);

    /**
     * 获取商品的详细信息
     */
    @PostMapping("/Shop/ListProductInfoByIdList")
    ProductInfosDto listProductInfos(@RequestBody GetProductInfoDto getProductInfoDto);



    /**
     * 根据skuid查询spu信息
     * @return
     */
    @PostMapping("/Product/GetSpectionProductBySkuId")
    ProductListDto getSpuIdsBySkuIds(@RequestBody GetSpuIdsBySkuIdsDto requestDto);

    /**
     * 查询门店餐具商品
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/Shop/ListDishwareProduct", produces = MediaType.APPLICATION_JSON_UTF8_VALUE, consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ShopBaseResponseDto<List<ProductListDto.DataBean>> findDishWareProductList(@RequestBody GetShopDishWareProductDto request);

}
