/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderChannelType
 * @Package cn.freemud.enums
 * @Description:
 * @author: liming.guo
 * @date: 2018/7/3 15:06
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.enums;

public enum OrderChannelType {

    SAAS("saas", "saas小程序"),

    IMG("img", "爱马哥小程序"),

    MALL("mall", "商城");

    private String code;

    private String desc;

    OrderChannelType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static OrderChannelType getByCode(String code) {
        for (OrderChannelType type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
