package cn.freemud.service.adapter;

import cn.freemud.entities.vo.CreateOrderVo;
import cn.freemud.enums.CreateOrderType;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;

import java.util.Objects;

/**
 * 到店订单检查
 */
public class ToStoreCheck extends AbstractOrderCheck {
    @Override
    public boolean support(int orderType) {
        return CreateOrderType.COLLECT_GOODS.getCode() == orderType;
    }

    @Override
    public void check(CreateOrderVo vo, StoreResponse storeResponse) {
        StoreResponse.BizVO bizVO = storeResponse.getBizVO();
        StoreResponse.Configuration storeConfig = bizVO.getStoreConfig();
        // 关闭预约单
        if (Objects.equals(storeConfig.getSelfMentionSwitch(), 0))  {
            super.doStoreStateCheck(bizVO);
        }
    }

}
