package cn.freemud.management.adapter;

import cn.freemud.management.enums.OperateType;
import com.alibaba.fastjson.JSONObject;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtInfoDto;
import com.freemud.application.sdk.api.structure.request.PushMessageNoticeDto;
import com.freemud.sdk.api.assortment.message.enums.MessageEventType;
import com.freemud.sdk.api.assortment.message.request.MessagePushOrderTemplateRequest;
import com.freemud.sdk.api.assortment.message.request.MessageTemplateRequest;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.stereotype.Component;

@Component
public class MessagePushAdapter {

    public PushMessageNoticeDto convent2PushMessageNoticeDto(Integer targetType, String partnerId,
                                                             String storeId, String userId, String oid, Integer deliveryStatus, Integer cmdType) {
        PushMessageNoticeDto pushMessageNoticeDto = new PushMessageNoticeDto();
        pushMessageNoticeDto.setPartnerId(partnerId);
        pushMessageNoticeDto.setStoreId(storeId);
        pushMessageNoticeDto.setTargetId(userId);
        pushMessageNoticeDto.setTargetType(targetType);
        pushMessageNoticeDto.setCmd(cmdType);
        pushMessageNoticeDto.setTtl(0);
        pushMessageNoticeDto.setVer("1");
        PushMessageNoticeDto.Message message = new PushMessageNoticeDto.Message();
        message.setType(1);
        if (targetType == 2) {
            PushMessageNoticeDto.Message.Content content = new PushMessageNoticeDto.Message.Content();
            content.setOid(oid);
            content.setDeliveryStatus(deliveryStatus);
            message.setContent(content);
        }
        pushMessageNoticeDto.setData(JSONObject.toJSONString(message));
        return pushMessageNoticeDto;
    }

    public MessageTemplateRequest<MessagePushOrderTemplateRequest> convent2MessageTemplateRequest(QueryOrdersResponse.DataBean.OrderBean order, String reason, OperateType opType) {
        OrderExtInfoDto extInfo = JSONObject.parseObject(order.getExtInfo(), OrderExtInfoDto.class);
        if (extInfo==null){
            return null;
        }
        MessageTemplateRequest<MessagePushOrderTemplateRequest> messageTemplateRequest = new MessageTemplateRequest<>();
        messageTemplateRequest.setAppId(extInfo.getAppid());
        messageTemplateRequest.setPartnerId(order.getCompanyId());
        MessagePushOrderTemplateRequest messagePushOrderTemplateRequest = new MessagePushOrderTemplateRequest();
        messagePushOrderTemplateRequest.setAddress(order.getAddress());
        messagePushOrderTemplateRequest.setDaySeq(order.getDaySeq());
        messagePushOrderTemplateRequest.setGmtExpect(order.getGmtExpect());
        messagePushOrderTemplateRequest.setShopName(order.getShopName());
        messagePushOrderTemplateRequest.setOpenId(extInfo.getOpenid());
        messagePushOrderTemplateRequest.setGmtCreate(order.getGmtCreate());
        messagePushOrderTemplateRequest.setOrderId(order.getOid());
        messagePushOrderTemplateRequest.setPrepayId(extInfo.getPrepayId());
        messagePushOrderTemplateRequest.setFormId(extInfo.getFormId());
        messagePushOrderTemplateRequest.setOrderType(order.getType());
        messagePushOrderTemplateRequest.setOtherCode(order.getOtherCode());
        messagePushOrderTemplateRequest.setAmount(Double.valueOf(order.getAmount()));
        messagePushOrderTemplateRequest.setReason(reason);
        messageTemplateRequest.setData(messagePushOrderTemplateRequest);

        MessageEventType messageEventType = null;
        switch (opType) {
            case ORDER_REJECT:
                messageEventType = MessageEventType.REJECTORDER;
                break;
            case ORDER_DONE:
                messageEventType = MessageEventType.DONEORDER;
                break;
            case ORDER_SEND:
                //外卖订单送出发微信模板消息
                if (ObjectUtils.equals(1, order.getType())) {
                    messageEventType = MessageEventType.DELIVERYORDER;
                } else {
                    messageEventType = MessageEventType.APPRAISEORDER;
                }
                break;
            case ORDER_AFFIRM:
                messageEventType = MessageEventType.APPRAISEORDER;
                break;
            case ORDER_REJECT_REFUND:
                messageEventType = MessageEventType.REFUNDREJECTORDER;
                break;
            default:
                messageEventType = null;
        }
        messageTemplateRequest.setMessageEventType(messageEventType);
        return messageTemplateRequest;
    }
}
