package cn.freemud.handler;

import cn.freemud.entities.dto.blacklist.BlacklistDto;
import cn.freemud.entities.dto.blacklist.OrderBlacklistResp;
import cn.freemud.entities.dto.blacklist.Result;
import cn.freemud.entities.dto.blacklist.req.BlackListQueryByClient;
import cn.freemud.entities.dto.blacklist.resp.MemberBlacklistVO;
import cn.freemud.service.thirdparty.DataCenterClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2022/5/27 11:59
 * @description :
 */
@Component
public class MemberBlacklistHandler {

    @Autowired
    private DataCenterClient dataCenterClient;

    /**
     * 查询用户是否在黑名单中
     *
     * @param blacklistDto
     */
    public String checkisTrueBlacklist(BlacklistDto blacklistDto) {
        //step1 查询是否存在
        BlackListQueryByClient req = new BlackListQueryByClient();
        req.setPartnerId(blacklistDto.getPartnerId());
        req.setMemberId(blacklistDto.getMemberId());
        // 默认只查询消费黑名单
        req.setRecordType(BlackListQueryByClient.RECORD_TYPE_CUSTOMER);
        Result<MemberBlacklistVO> memberBlacklistVOResult = dataCenterClient.queryByMemberId(req);
        if (!memberBlacklistVOResult.isOk()) {
            return null;
        }
        MemberBlacklistVO result = memberBlacklistVOResult.getResult();
        if (!result.isExist()) {
            return null;
        }
        //step2 存在校验剩余余额
        Long limitAmount = result.getLimitAmount();
        Long shoppingTotalAmount = result.getShoppingTotalAmount();
        if (limitAmount.compareTo(shoppingTotalAmount + blacklistDto.getAmount()) >= 0) {
            // 满足
            return null;
        }
        // step3 余额不足组装前端参数  考虑负数默认0
        long surplusAmount = limitAmount - shoppingTotalAmount;

//        OrderBlacklistResp orderBlacklistResp = new OrderBlacklistResp();
//        orderBlacklistResp.setMoblie(result.getMoblie());
//        orderBlacklistResp.setSurplusAmount(surplusAmount < 0 ? 0L : surplusAmount);
//        return orderBlacklistResp;
        // 您的消费额度还有3元，暂无法支付，如有疑问，详询客服热线4008899096
        StringBuilder sb = new StringBuilder();
        long amount = surplusAmount < 0L ? 0L : surplusAmount * 100;
        sb.append("您的消费额度还有")
                .append(amount)
                .append("元，暂无法支付，如有疑问，详询客服热线")
                .append(result.getMoblie());
        return sb.toString();

    }
}
