package cn.freemud.controller;


import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.*;
import cn.freemud.service.MCCafeOrderService;
import cn.freemud.service.Orderservice;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import com.freemud.application.sdk.api.log.LogParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping("/order")
@RestController
@Validated
public class McCafeController {

    @Autowired
    private Orderservice orderservice;

    @Autowired
    private MCCafeOrderService mcCafeOrderService;


    /**
     * 麦咖啡创建订单
     */
    @ApiAnnotation(logMessage = "createMCCafeOrder")
    @PostMapping("/MCoffee/createMCCafeOrder")
    public BaseResponse createOrderMCCafe(@Validated @LogParams @RequestBody CreateOrderVo createOrderVo) {
        return mcCafeOrderService.createMCCafeOrder(createOrderVo);
    }

    /**
     * 麦咖啡订单支付成功后通知
     */
    @ApiAnnotation(logMessage = "mcCafePaySuccessCallback")
    @PostMapping({"/MCoffee/mcCafePaySuccessCallback","/openStoreMCCafeQueryPaymentCallback"})
    public String mcCafePaySuccessCallback(@LogParams @RequestBody NewPaysuccessNoticeMessage message) {
        return mcCafeOrderService.mcCafePaySuccessCallback(message);
    }

    /**
     * 查询麦咖啡订单列表
     */
    @ApiAnnotation(logMessage = "maCafeQueryOrders")
    @PostMapping("/maCafeQueryOrders")
    public BaseResponse maCafeQueryOrders(@Validated @LogParams @RequestBody McCafeQueryOrderVo queryOrderVo) {
        return mcCafeOrderService.mcCafeQueryOrders(queryOrderVo);
    }

    /**
     * 麦咖啡 获取订单详情
     */
    @ApiAnnotation(logMessage = "mcCafeQueryOrderById")
    @PostMapping("/mcCafeQueryOrderById")
    public BaseResponse mcCafeQueryOrderById(@Validated @LogParams @RequestBody MaCafeQueryOrderVo queryOrderVo) {
        return mcCafeOrderService.mcCafeQueryOrderById(queryOrderVo);
    }

    /**
     * 麦咖啡用户申请退款
     */
    @ApiAnnotation(logMessage = "mcCafeRefund")
    @PostMapping("/MCoffee/mcCafeRefund")
    public BaseResponse mcCafeRefund(@Validated @LogParams @RequestBody OrderRefundVo orderRefundVo) {
        return mcCafeOrderService.orderRefund(orderRefundVo);
    }

    /**
     * 退款回掉通知
     */
    @ApiAnnotation(logMessage = "mcCafeRefundNotifyCallback")
    @PostMapping("/MCoffee/mcCafeRefundNotifyCallback")
    public String mcCafeRefundNotifyCallback(@LogParams @RequestBody RefundNotifyCallbackRequestVo requestVo) {
        return mcCafeOrderService.mcCafeRefundNotifyCallback(requestVo);
    }

    /**
     * 根据订单号查询订单状态和取餐码
     */
    @ApiAnnotation(logMessage = "mcCafePollingPickUpCode")
    @PostMapping("/mcCafePollingPickUpCode")
    public BaseResponse mcCafePollingPickUpCode(@Validated @LogParams @RequestBody MaCafeQueryOrderVo vo) {
        return mcCafeOrderService.mcCafePollingPickUpCode(vo);
    }

    /**
     * 麦咖啡催单
     */
    @ApiAnnotation(logMessage = "reminder")
    @PostMapping("/reminder")
    public BaseResponse reminder(@Validated @LogParams @RequestBody ReminderVo reminderVo) {
        return mcCafeOrderService.reminder(reminderVo);
    }

    /**
     * 麦咖啡根据订单号查询骑手位置
     */
    @ApiAnnotation(logMessage = "listFreeRider")
    @PostMapping("/listFreeRider")
    public BaseResponse listFreeRider(@Validated @LogParams @RequestBody FreeRiderPositionVo vo) {
        return mcCafeOrderService.listFreeRider(vo);
    }

    /**
     * 查询麦咖啡最近已完成的一单
     */
    @ApiAnnotation(logMessage = "mcCafeQueryRecentOrder")
    @PostMapping("/mcCafeQueryRecentOrder")
    public BaseResponse mcCafeQueryRecentOrder(@Validated @LogParams @RequestBody McCafeQueryOrderVo queryOrderVo) {
        return mcCafeOrderService.mcCafeQueryRecentOrder(queryOrderVo);
    }



    /**
     * 麦咖啡推送订单数据到麦当劳
     */
    @ApiAnnotation(logMessage = "mcCafePushOrder")
    @PostMapping("/mcCafePushOrder")
    public BaseResponse mcCafePushOrder(@Validated @LogParams @RequestBody McCafeQueryOrderVo queryOrderVo) {
        return mcCafeOrderService.mcCafePushOrder(queryOrderVo);
    }



    /**
     * 麦咖啡推送订单数据到麦当劳 -- 补偿/修正
     */
    @ApiAnnotation(logMessage = "mcCafePushOrderMakeUp")
    @PostMapping("/mcCafePushOrderMakeUp")
    public BaseResponse mcCafePushOrderMakeUp(@Validated @LogParams @RequestBody McCafeQueryOrderVo queryOrderVo) {
        return mcCafeOrderService.mcCafePushOrderMakeUp(queryOrderVo);
    }



}


