package cn.freemud.service.impl.calculate;

import cn.freemud.entities.dto.UserLoginInfoDto;
import cn.freemud.entities.dto.activity.ActivityQueryDto;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountResponseDto;
import cn.freemud.entities.vo.CartGoods;
import cn.freemud.entities.vo.CouponPromotionVO;
import cn.freemud.entities.vo.ShoppingCartGoodsResponseVo;
import cn.freemud.entities.vo.ShoppingCartInfoRequestVo;
import cn.freemud.service.impl.calculate.promotion.BuyOneGiveOneSendService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: cn.freemud.service.impl.calculate CalculationSharingDiscountServiceImpl
 * @Description: 校验活动信息
 * @author: pengfei.liu
 * @date: 2020/11/27
 * @Copyright: www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
@Slf4j
public class CalculationSharingValidatorService {


    @Autowired
    private BuyOneGiveOneSendService buyOneGiveOneSendService;


    public void validator(CalculationSharingDiscountResponseDto.CalculationDiscountResult discountResult
            , List<CartGoods> cartGoodsList
            , ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo
            , ShoppingCartInfoRequestVo shoppingCartInfoRequestVo
            , UserLoginInfoDto userLoginInfoDto
            , CouponPromotionVO couponPromotionVO
            , ActivityQueryDto activityQueryDto
            , String menuType
            , Long deliveryAmount
            , String opt) {


        // 买一赠一寄件活动
        buyOneGiveOneSendService.validator(discountResult,cartGoodsList,shoppingCartInfoRequestVo,activityQueryDto,shoppingCartGoodsResponseVo);
    }

}
