/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderRelationFactoryImpl
 * @Description:
 * @author: pengfei.liu
 * @date: 2020/11/23
 * @version V1.0
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service.order.impl;

import cn.freemud.service.order.OrderRelationFactory;
import cn.freemud.service.order.OrderRelationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class OrderRelationFactoryImpl implements OrderRelationFactory {

    /**
     * coco商户
     */
    @Value("#{'${coco.partnerId}'.split(',')}")
    private List<String> cocoPartnerId;

    /**
     * coco的订单相关
     */
    @Autowired
    @Qualifier("cocoOrderRelationService")
    OrderRelationService cocoOrderRelationService;

    /**
     * 平台的订单相关
     */
    @Autowired
    @Qualifier("platformOrderRelationServiceImpl")
    OrderRelationService PlatformOrderRelationServiceImpl;

    @Override
    public OrderRelationService getCreateOrderTimeCheckService(String partnerId) {

        if(cocoPartnerId.contains(partnerId)){
            return cocoOrderRelationService;
        }else{
            return PlatformOrderRelationServiceImpl;
        }
    }

}
