package cn.freemud.entities.dto;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Objects;

@Data
public class ActivityCalculationDiscountRequestDto {
    /**
     * 区域
     */
    private String area;
    /**
     * 可用渠道
     */
    private String channel;
    /**
     * 渠道
     */
    private String productChannel;
    /**
     * 绑定的小程序id
     */
    private String appId;
    /**
     * i应用传isaas，快中台传fast
     */
    private String application = "isaas";
    /**
     * 是否展示活动列表 0：默认，不展示  1：展示
     */
    private Integer isShowActivities;
    /**
     * 是否显示商品的活动信息 0：默认，不展示  1：展示
     */
    private Integer isShowGoodsActivity;
    /**
     * 商户
     */
    private String partnerCode;
    /**
     * 门店
     */
    private String storeId;

    /**
     * 门店的组织机构树
     */
    private List<String> orgIds;

    /**
     * 用户id（有优惠券时，该字段必传）
     */
    private String userId;
    /**
     * 版本号
     */
    private Integer ver;
    /**
     * 优惠券集合
     */
    private List<CalculationDiscountCoupon> coupons;
    /**
     * 商品集合
     */
    private List<CalculationDiscountGoods> goods;

    private Long distributionFee;
    /**
     * 购买月卡费用(分)
     */
    private Long payCardFee;
    /**
     * 是否是会员
     */
    private Boolean isMember;

    @Data
    public static class CalculationDiscountCoupon {
        /**
         * 优惠券码
         */
        private String code;
        /**
         * 活动号
         */
        private String activityCode;
    }

    @Data
    public static class CalculationDiscountGoods {
        /**
         * 键位编号（麦咖啡）
         */
        private String goodsCode;
        /**
         * 商品核销券号
         */
        private String couponCode;
        /**
         * 商品ID
         */
        private String goodsId;
        /**
         * 购物车行uid
         */
        private String cartGoodsUid;
        /**
         * 加车时间
         */
        private Long addCartTime;
        /**
         * 商品品类
         */
        private String category;
        /**
         * 商品数量
         */
        private Integer goodsQuantity;
        /**
         * 原价（分）
         */
        private Long originalPrice;
        /**
         * 折扣比例
         * 例如8折为80
         */
        private Integer memberDiscount;
        /**
         * 加料
         */
        private List<Material> smallMaterial;
        private String spuId;

        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
                return false;
            CalculationDiscountGoods that = (CalculationDiscountGoods) o;
            return Objects.equals(goodsId, that.goodsId) &&
                    Objects.equals(category, that.category) &&
                    Objects.equals(cartGoodsUid, that.cartGoodsUid) &&
                    Objects.equals(originalPrice, that.originalPrice);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), goodsId, category, originalPrice);
        }

        @Data
        @NoArgsConstructor
        static public class Material {
            /**
             * 加料商品ID
             */
            private String goodsId;
            /**
             * 加料数量
             */
            private Integer goodsQuantity;
            /**
             * 加料原价
             */
            private Long originalPrice;
            /**
             * 加料现价
             */
            private Integer nowPrice;
            /**
             * 1 :小料、2：可选搭配
             */
            private int type;
        }
    }

}
