package cn.freemud.entities.dto;

import lombok.Data;

import java.util.Date;

@Data
public class OpenPlatformPartnerMerchantAccountDto {
    /**
     * 主键ID
     */
    private Long id;

    /**
     * 间联支付表主键id
     */
    private Long indirectId;

    /**
     * 收款账户名称
     */
    private String accountName;

    /**
     * 收款卡号 微信对应微信号
     */
    private String accountCard;

    /**
     * 商户ID
     */
    private String partnerId;

    /**
     * 支付商户号
     */
    private String mchId;

    /**
     * 间联渠道编号
     */
    private String platform;

    /**
     * 间联渠道名称
     */
    private String platformName;

    /**
     * 账户类型 1.商户 2个人微信号
     */
    private Integer accountType;

    /**
     * 收款比例 百分比
     */
    private String payRate;

    /**
     * 收款描述
     */
    private String payDescription;

    /**
     * 开始时间
     */
    private Date gmtCreated;

    /**
     * 修改时间
     */
    private Date gmtModified;
    /**
     * 支付手续费率
     */
    private String feeType;

    /**
     * 门店id
     */
    private String storeId;
}