/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CreateOrderRequest
 * @Package com.freemud.application.sdk.api.ordercenter.domain
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/1 16:25
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.application.sdk.api.ordercenter.request.create;

import com.freemud.application.sdk.api.ordercenter.request.BaseRequest;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtendedReq;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class CreateOrderRequest extends BaseRequest {

    //订单编号
    private String orderCode;

    //商户号
    private String partnerId;

    //商户名
    private String partnerName;

    //门店编号
    private String storeId;

    //第三方门店编号
    private String thirdStoreId;

    //门店名
    private String storeName;

    //门店全局唯一编号
    private String storeUnifyId;

    //目的门店
    private String toStoreId;

    //用户ID
    private String userId;

    //用户姓名
    private String userName;

    /**
     * 是否是父订单
     */
    private Boolean isParent;

    //默认为待支付状态，如需要则设置对应的值
    private Integer orderState;

    //正常情况下不要设置值，此字段仅在做订单同步时使用 订单子状态
    private Integer orderSubState;

    //订单类型 店内自取实时-1常规堂食 店内自取预约-2预约堂食 店外快递实时-3常规外卖，
    // 店外快递预约-4预约外卖 店外自取实时-5常规自取 店外自取预约-6预约自取
    private Integer orderType;

    //正常情况下不要设置值，此字段仅在做订单同步时使用
    private Integer payState;

    //1:线上支付 2:线下支付
    private Integer payType;

    //当前支付请求号
    private String payRequestNo;

    //支付渠道
    private String payChannel;

    //支付渠道名称
    private String payChannelName;

    //配送状态
    private Integer deliveryState;

    //订单原始金额，单位分
    private Long originalAmount;

    //用户在界面上看到的支付金额
    private Long settlementAmount;

    //实际支付现金金额，扣除支付自生优惠，单位分
    private Long actualPayAmount;

    //是否需要开发票
    private Boolean needInvoice;

    //下单渠道必填，根据此字段的值判断是自营或第三方，来走不同的状态机 详细见 orderClientType枚举
    private Integer orderClient;

    //商户自己生成的订单号
    private String companySelfCode;

    //第三方订单号/客户展示订单编号
    private String thirdOrderCode;

    //订单备注
    private String note;

    //扩展字段
    private String extInfo;

    //取货号 取餐号
    private String pickUpGoodsNo;

    //订单特殊类型 1:普通订单 2:拼团订单 3:秒杀订单 4:拼单订单
    private Integer marketingType;

    //销售类型对应的场景值
    private String marketingCode;

    //配送类型 1自配送(三方渠道配送、商家店员配送) 2平台配送")
    private Integer expressType;

    //配送渠道名称
    private String expressChannelName;

    //配送渠道编号
    private String expressChannelCode;

    //快递单号
    private String expressNo;

    //重量
    private Double weight;

    //是否能退货 是否有退货商品
    private Boolean canRefund;

    //支付时间
    private Date payTime;

    //发货时间
    private Date deliveryTime;

    //签收时间 送达时间 收货时间
    private Date receiveTime;

    //桌台号
    private String barCounter;

    //pos编号
    private String posCode;

    //就餐人数
    private Integer dinersNumber;

    //小程序本地tableKey
    private String localTableKey;

    //@ApiModelProperty(value = "pos table key")
    private String posTableKey;

    //用户预约时间，仅为预约单时存放
    private Date expectTime;

    //打印次数
    private Integer printNum;

    //订单业务类型 1:普通订单 2:虚拟订单
    /**
     * 1: ; 2:
     */
    private Integer bizType;

    //挂起状态 0 正常 1 未成团挂起 2 风控挂起 3 售中取消挂起
    private Byte suspendState;

    //挂起状态描述
    private String suspendDesc;

    //承诺送达标识  0-无承诺 60-1小时达 120-2小时达 180-3小时达 1440-隔日达
    private Short deliveryPromise;

    //预计送达时间
    private String estimateDeliveryCompleteTime;

    //@ApiModelProperty(value = "发票明细")
//    private OrderInvoiceReq orderInvoice;

    //订单商品信息
    List<OrderItemCreateReq> orderItemList;

    //订单费用信息
    List<OrderCostCreateReq> orderCostDetailList;

    //订单结算信息
    List<OrderSettlementCreateReq> orderSettlementDetailList;

    //配送联系信息
    List<DeliveryContactInfoCreateReq> deliveryContactInfoList;

    //订单扩展信息 （门店渠道信息）
    private OrderExtendedReq orderExtended;

    //操作人
    private String operator;

    /**
     * 微信、支付宝、APP渠道appid
     */
    private String appId;

    private Byte payChannelType;
    private List<OrderPayItemCreateReq> orderPayItemCreateReqList;
    /**
     * 买一赠一选择的商品
     */
    private List<ChooseGood> orderSendCouponRespList;

    @Data
    public static class ChooseGood {

        /**
         * 活动类型
         */
        private Integer activeType;

        /**
         * 活动号
         */
        private String activeCode;

        /**
         * 赠送商品id
         */
        private String goodsId;

        /**
         * 赠送商品名称
         */
        private String goodsName;

        /**
         * 赠送商品数量
         */
        private Integer qty;

        /**
         * 可兑换商品券编号
         */
        private String couponCode ;

        /**
         * 商品券兑换数量
         */
        private Integer couponQty;

        /**
         *  是否已选择寄杯
         */
        private Boolean sendCoupon;
    }

}
