package cn.freemud.service.impl.calculate;

import cn.freemud.constant.ShoppingCartConstant;
import cn.freemud.entities.dto.UserLoginInfoDto;
import cn.freemud.entities.dto.activity.ActivityDiscountsDto;
import cn.freemud.entities.dto.activity.ActivityQueryDto;
import cn.freemud.entities.dto.calculate.*;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.ActivityTypeEnum;
import cn.freemud.enums.OrderChannelType;
import cn.freemud.handle.PromotionCommonMethodHandle;
import cn.freemud.service.impl.calculate.promotion.*;
import com.freemud.sdk.api.assortment.shoppingcart.enums.BusinessTypeEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: cn.freemud.service.impl.calculate CalculationSharingEquallyService
 * @Description: TDO 描述....
 * @author: family
 * @date: 2020/9/14
 * @Copyright: www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
public class CalculationSharingEquallyService {

    @Autowired
    private CalculationCommonService calculationCommonService;
    @Autowired
    private GiftSharingService giftSharingService;
    @Autowired
    private ScoreSharingService scoreSharingService;

    @Autowired
    private DeliverySharingService deliverySharingService;

    @Autowired
    private AdditionSharingService additionSharingService;

    @Autowired
    private CouponSharingService promotionSharingService;

    @Autowired
    private PromotionCommonMethodHandle promotionCommonMethodHandle;
    /**
     * 均摊服务
     * @param discountResult
     * @param cartGoodsList
     * @param shoppingCartGoodsResponseVo
     * @param shoppingCartInfoRequestVo
     * @param userLoginInfoDto
     * @param couponPromotionVO
     * @param activityQueryDto
     * @param menuType
     * @param deliveryAmount
     * @param shoppingCartGoodsDto
     * @param premiumExchangeActivity
     */
    public void equally(CalculationDiscountResult discountResult
            , List<CartGoods> cartGoodsList
            , ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo
            , ShoppingCartInfoRequestVo shoppingCartInfoRequestVo
            , UserLoginInfoDto userLoginInfoDto
            , CouponPromotionVO couponPromotionVO
            , ActivityQueryDto activityQueryDto
            , String menuType
            , Long deliveryAmount
            , ShoppingCartGoodsDto shoppingCartGoodsDto
            , CreateOrderVo.PremiumExchangeActivity premiumExchangeActivity, long nightDistributionFee) {

        calculationCommonService.initShoppingCart(discountResult,
                cartGoodsList,
                shoppingCartGoodsResponseVo,
                couponPromotionVO != null ? couponPromotionVO.getCouponCode() : null,
                shoppingCartInfoRequestVo);
        if (BusinessTypeEnum.SAAS_MALL.getCode().equals(menuType) && null != shoppingCartInfoRequestVo && OrderChannelType.SAASMALL.getCode().equalsIgnoreCase(shoppingCartInfoRequestVo.getChannelType())) {
            deliverySharingService.mallDeliveryResponse(shoppingCartGoodsResponseVo, deliveryAmount,discountResult);
        }
        /**
         * 商品券\换购券
         */

        promotionSharingService.equally(discountResult, cartGoodsList, couponPromotionVO);
        List<ShoppingCartGoodsDto.CartGoodsDetailDto> cartGoodsDetailDtoList = CollectionUtils.isEmpty(shoppingCartGoodsDto.getProducts()) ? new ArrayList<>() : shoppingCartGoodsDto.getProducts();
        shoppingCartGoodsDto.setProducts(cartGoodsDetailDtoList);

        /**
         * 组建大的优惠信息
         */
        this.setShoppingCartGoodsDtoActivityDiscounts(discountResult, shoppingCartGoodsDto);
        /**
         * 活动库存
         * 过滤出加价购
         */

        if (null != discountResult) {
            List<Discount> addMoneyDiscounts = discountResult.getDiscounts()
                    .stream()
                    .filter(discount -> ActivityTypeEnum.TYPE_81.getCode().equals(discount.getType()))
                    .collect(Collectors.toList());
            List<SubtractStockVO> stocks = filterSendGoodsStocks(discountResult.getStocks(), shoppingCartInfoRequestVo, addMoneyDiscounts);
            if (CollectionUtils.isNotEmpty(stocks)) shoppingCartGoodsDto.setStocks(stocks);
        }
        List<Goods> goods = null;
        if (discountResult !=null) {
            goods = discountResult.getGoods();
        }

        /**
         * 利用促销赋值totalDiscountAmount
         */
        shoppingCartGoodsResponseVo.setProducts(cartGoodsList);
        Goods find = null;
        for (CartGoods product : shoppingCartGoodsResponseVo.getProducts()) {
            if (goods!=null) {
                Optional<Goods> first = goods.stream().filter((k) -> k.getCartGoodsUid().equals(product.getCartGoodsUid())).findFirst();
                if (first.isPresent()) {
                    find = first.get();
                }
            }
            ShoppingCartGoodsDto.CartGoodsDetailDto cartGoodsDetailDto = calculationCommonService.convertCartGoods2DetailGoodsList(find, product,shoppingCartInfoRequestVo.getPartnerId());
            cartGoodsDetailDtoList.add(cartGoodsDetailDto);
        }

        /**
         * 赠品
         */
        giftSharingService.equally(discountResult, cartGoodsDetailDtoList, activityQueryDto, menuType, userLoginInfoDto);

        /**
         * 加价购商品
         */
        additionSharingService.equally(shoppingCartInfoRequestVo, shoppingCartGoodsDto, discountResult, premiumExchangeActivity, shoppingCartGoodsResponseVo);

        /**
         * 积分抵扣
         */
        scoreSharingService.scoreResponse(discountResult, shoppingCartGoodsResponseVo, userLoginInfoDto, shoppingCartInfoRequestVo);
        scoreSharingService.equally(shoppingCartGoodsResponseVo, shoppingCartGoodsDto);
        calculationCommonService.getNeedCardAmount(shoppingCartInfoRequestVo, shoppingCartGoodsDto);

        if(BusinessTypeEnum.SAAS_DELIVERY.getCode().equals(menuType)){
            deliverySharingService.deliveryResponse(discountResult, activityQueryDto, shoppingCartGoodsResponseVo, deliveryAmount, nightDistributionFee);
        }

        calculationCommonService.setAddAndUpdateResponse(cartGoodsList, shoppingCartGoodsResponseVo, shoppingCartInfoRequestVo, ShoppingCartConstant.QUERY_INFO);
        calculationCommonService.addNeedCardAmount(shoppingCartInfoRequestVo, shoppingCartGoodsResponseVo);
        if (discountResult!=null && discountResult.getSendPointVo()!=null) {
            shoppingCartGoodsDto.setSendPoint(discountResult.getSendPointVo());
        }
        shoppingCartGoodsDto.setDeliveryAmount(shoppingCartGoodsResponseVo.getDeliveryAmount());
        shoppingCartGoodsDto.setDiscountDeliveryAmount(shoppingCartGoodsResponseVo.getDiscountDeliveryAmount());
        shoppingCartGoodsDto.setThresholdAmount(shoppingCartGoodsResponseVo.getThresholdAmount());
        shoppingCartGoodsDto.setIsDiscountDelivery(shoppingCartGoodsResponseVo.getIsDiscountDelivery());
        shoppingCartGoodsDto.setDiscountDeliveryActivityCode(shoppingCartGoodsResponseVo.getDiscountDeliveryActivityCode());
        //总计价
        shoppingCartGoodsDto.setPackageAmount(shoppingCartGoodsResponseVo.getNewPackAmount());
        shoppingCartGoodsDto.setPackageAmountCollectType(shoppingCartGoodsResponseVo.getPackageAmountCollectType());
        shoppingCartGoodsDto.setOriginalTotalAmount(shoppingCartGoodsResponseVo.getOriginalTotalAmount());
        shoppingCartGoodsDto.setTotalAmount(shoppingCartGoodsResponseVo.getTotalAmount());
        shoppingCartGoodsDto.setTotalDiscountAmount(shoppingCartGoodsResponseVo.getTotalDiscountAmount());
    }

    /**
     * 设置购物车整体享受的活动集合
     *
     * @param discountResult
     * @param shoppingCartGoodsDto
     */
    public void setShoppingCartGoodsDtoActivityDiscounts(CalculationDiscountResult discountResult
            , ShoppingCartGoodsDto shoppingCartGoodsDto) {


        List<ActivityDiscountsDto> activityDiscountsDtos = new ArrayList<>();
        shoppingCartGoodsDto.setActivityDiscountsDtos(activityDiscountsDtos);
        if (discountResult == null) return;
        Integer type = 2;
        List<ActivityTypeEnum> activityTypeEnums = new LinkedList<>();
        activityTypeEnums.add(ActivityTypeEnum.TYPE_11);
        activityTypeEnums.add(ActivityTypeEnum.TYPE_12);
        activityTypeEnums.add(ActivityTypeEnum.TYPE_3);
        activityTypeEnums.add(ActivityTypeEnum.TYPE_31);
        List<Integer> typeEnums = activityTypeEnums.stream().map(ActivityTypeEnum::getCode).collect(Collectors.toList());
        for (Goods good : discountResult.getGoods()) {
            if (CollectionUtils.isNotEmpty(good.getSmallMaterial())) {
                List<SmallMaterial> sm = good.getSmallMaterial()
                        .stream()
                        .filter(d -> type.equals(d.getType())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(sm)) continue;
                for (SmallMaterial s : sm) {
                    if (CollectionUtils.isEmpty(s.getDiscounts())) continue;
                    HashMap<Integer, Long> discountMap = new HashMap<>();
                    for (GoodsDiscount d : s.getDiscounts()) {
                        if (!typeEnums.contains(d.getType())) continue;
                        Integer sType = d.getType();
                        discountMap.put(sType, d.getDiscount());
                    }

                    if (discountMap.isEmpty()) continue;
                    if (CollectionUtils.isEmpty(good.getDiscounts())) continue;
                    for (GoodsDiscount discount : good.getDiscounts()) {
                        Integer mType = discount.getType();
                        if (discountMap.get(mType) != null) {
                            discount.setDiscount(discount.getDiscount() + discountMap.get(mType).longValue());
                        }
                    }
                }
            }
        }
        List<Discount> discounts = discountResult.getDiscounts();
        for (Discount discount : discounts) {
            int discountAmount = (discount.getDiscount() == null) ? 0 : discount.getDiscount();
            Integer discountType = discount.getType();
            if (discountType != null && discountAmount >= 0) {
                //加价购金额为0不记录
                if(Objects.equals(ActivityTypeEnum.TYPE_81.getCode(),discountType) && discountAmount == 0){
                    continue;
                }
                ActivityDiscountsDto activityDiscountsDto = new ActivityDiscountsDto();
                activityDiscountsDto.setActivityCode(discount.getActivityCode());
                activityDiscountsDto.setActivityName(discount.getActivityName());
                activityDiscountsDto.setActivityType(calculationCommonService.convertType(discountType));
                activityDiscountsDto.setDiscountAmount(0 - discountAmount);
                activityDiscountsDto.setPriority(discount.getPriority());
                activityDiscountsDtos.add(activityDiscountsDto);
            }
        }
        //鬼知道促销会有什么问题，反正qa已经出现促销某种情况下没有返回priority字段了，这里为空置位0，防止排序npe影响购物车
        activityDiscountsDtos.stream().forEach(a -> { if (null==a.getPriority()) a.setPriority(0); });
        //美团POS需求，将优惠信息按照优惠优先级排序
        activityDiscountsDtos.sort((a1, a2) -> a2.getPriority() - a1.getPriority());
        shoppingCartGoodsDto.setActivityDiscountsDtos(activityDiscountsDtos);
    }

    /**
     * 库存扣减加价购商品 要过滤掉没有换购的商品
     *
     * @param stocks                    扣减库存
     * @param shoppingCartInfoRequestVo 购物车请求信息
     * @param addMoneyDiscounts         加价购活动
     * @return 返回应该扣减的加价购商品库存
     */
    private List<SubtractStockVO> filterSendGoodsStocks(List<SubtractStockVO> stocks
            , ShoppingCartInfoRequestVo shoppingCartInfoRequestVo
            , List<Discount> addMoneyDiscounts) {
        return promotionCommonMethodHandle.filterSendGoodsStocks(stocks, shoppingCartInfoRequestVo, addMoneyDiscounts);
    }

}
