package com.freemud.application.sdk.api.ordercenter.request.carpark;


import com.freemud.application.sdk.api.ordercenter.request.create.OrderSettlementCreateReq;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.Valid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author hongwang
 */
@Getter
@Setter
@ToString
public class ParkingOrderAffirmReq {

    private String appId;

   /*** "订单号"***/
    private String orderCode;

   /*** "实际支付现金金额，扣除支付自生优惠，单位分"***/
    private BigDecimal actualPayAmount;

   /*** "订单结算信息"***/
    @Valid
   List<OrderSettlementCreateReq> orderSettlementDetailList = new ArrayList<>();

   /*** "支付方式："+ PayChannelType.API_DESC***/
    private Byte payChannelType;

   /*** "支付成功时间"***/
    private Date payTime;

   /*** "支付凭证请求号"***/
    private String payRequestNo;

   /*** "操作人"***/
    private String operator;

    /***"发票明细"**/
    private OrderInvoiceReq orderInvoice;

    /***"车牌号"**/
    private String carNumber;

    /***"停车场ID"**/
    private String parkingAreaId;

    /***"停车场名称"**/
    private String parkingAreaName;

    /***"手机号"**/
    private String mobile;

    /***"第三方订单号"**/
    private String thirdOrderCode;

    /***"入场时间"**/
    private Date inTime;

    /***"出场时间"**/
    private Date outTime;

    /***"门店编号"**/
    private String storeId;

    /***"门店名称"**/
    private String storeName;

    /***"订单金额"**/
    private BigDecimal originalAmount;

    /*******商户名称****/
    private String partnerName;

    /**
     * 商户号 必传字段
     */
    private String partnerId;

}
