package cn.freemud.entities.dto.store;

import lombok.Data;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/7/22 下午3:12
 * @description :
 */
@Data
public class DeliveryInfoDTO {

    /**
     * 每增加公里（单位米）
     */
    private String addRange;

    /**
     * 每增加公里增加配送费（单位分）
     */
    private Integer addRangeAmount;

    /**
     * 基础配送费（分）
     */
    private Integer deliveryAmount;

    /**
     * 配送方式:1-三方物流配送、2-商家自配送
     */
    private Integer deliveryMethod;

    /**
     * 配送半径
     */
    private Integer deliveryRadius;

    /**
     * 基础配送距离（单位米）
     */
    private String deliveryRange;

    /**
     * 手绘经纬度集合
     */
    private String deliveryScope;

    /**
     * 外卖起送条件（1:杯数，2:金额）
     */
    private Integer deliveryType;

    /**
     * 起送杯数
     */
    private Integer freeDeliveryCup;

    /**
     * 起送价格（单位分）
     */
    private Integer freeDeliveryPrice;

    /**
     * 所属商户号
     */
    private String partnerId;

    /**
     * 配送范围类型 1 自定义 2 半径
     */
    private Integer scopeConfig;

    /**
     * 扩展字段信息
     */
    private DeliveryInfoExpFields expandFields;

    /**
     * 配送区域名称
     */
    private String areaName;

    /**
     * 下单范围类型 1手工画范围 2半径服务
     */
    private Integer positionScopeType;

    /**
     * 起送价格（分）
     */
    private String minOrderPrice;

    /**
     * 配送费（分）
     */
    private String deliveryFee;

    /**
     * 配送时间（分钟）
     */
    private Integer deliveryTime;

    /**
     * 下单范围，格式：jsonArray，或者半径（米）
     */
    private String positionScope;

    /**
     * 实际需要支付配送费
     */
    private Integer finalDeliveryAmount;

    /**
     * 配送费为零的原因：0:正常,1:超出配送范围
     */
    private Integer deliveryFeeZeroReason = 0;
    
}
