package cn.freemud.controller;


import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.TakeMealNoticesVO;
import cn.freemud.service.CallerService;
import cn.freemud.utils.ResponseUtil;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import com.freemud.application.sdk.api.log.LogParams;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 叫号器
 */
@RequestMapping("order/caller")
@RestController
@Validated
public class CallerController {

    private CallerService callerService;

    public CallerController(CallerService callerService) {
        this.callerService = callerService;
    }

    /**
     * 取餐通知
     *
     * @return
     */
    @PostMapping("/takeMealNotices")
    @ApiAnnotation(logMessage = "takeMealNotices")
    public BaseResponse takeMealNotices(@Validated @LogParams @RequestBody TakeMealNoticesVO vo) {
        return callerService.takeMealNotices(vo);
    }

}
