package cn.freemud.service.thirdparty;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.GetStoreCloudPrintDto;
import cn.freemud.entities.dto.GetStoreCloudPrintResponseDto;
import cn.freemud.entities.dto.OrderPrintDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "ASSISTANT-SERVICE",url = "${saas.assistantserviceclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface FMAssistantCloudPrintClient {

    /**
     * 申请退款小票打印
     */
    @PostMapping(value = "/assistant/cloudPrint/applyRefund/print")
    BaseResponse applyRefundPrint(@RequestBody OrderPrintDto orderPrintDto);
}
