package cn.freemud.service.thirdparty;

import cn.freemud.annotations.IgnoreFeignLogAnnotation;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.dto.GetMemberListRequestDto;
import cn.freemud.entities.dto.GetMemberListResponseDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "customer-service", url = "${saas.customertools.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface MemberToolsClient {


    /**
     * 根据会员手机号和商户获取会员信息
     */
    @IgnoreFeignLogAnnotation(logMessage = "getMemberList",excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.STATUS_CODE,messageFieldName=ResponseCodeKeyConstant.MSG)
    @PostMapping(value = "/customerservice/getMembers")
    GetMemberListResponseDto getMemberList(@RequestBody GetMemberListRequestDto getMemberListRequestDto);
}
