/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: StoreItemClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/16 9:39
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.management.thirdparty;

import cn.freemud.management.entities.dto.request.console.BizDTO;
import cn.freemud.management.entities.dto.request.console.ConsoleResponseDTO;
import cn.freemud.management.entities.dto.request.console.GetStoreMixRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient("CONSOLE-API")
@RequestMapping(produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public interface ConsoleApiClient {

    /**
     * v2获取门店信息
     * http://yapi.sandload.cn:3000/project/257/interface/api/60053 接口调用使用
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/api/v2/organization/getStoreMix")
    ConsoleResponseDTO<BizDTO> getStoreMix(GetStoreMixRequest request);
}
