/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartServiceTest
 * @Package cn.freemud.service
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/26 17:00
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service;

import cn.freemud.entities.dto.*;
import cn.freemud.service.thirdparty.ShoppingCartClient;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.assertj.core.util.Lists;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class ShoppingCartServiceTest {

    @Autowired
    private ShoppingCartClient cartClient;

    @Test
    public void addCartTest() throws JsonProcessingException {
        AddShoppingCartRequestDto addShoppingCartRequestDto = new AddShoppingCartRequestDto();
        addShoppingCartRequestDto.setMerchantId("2343242");
        addShoppingCartRequestDto.setStoreId("fm001");
        addShoppingCartRequestDto.setUserId("wx001");
        List<ShoppingCartProductDto> productDtos = Lists.newArrayList();
        ShoppingCartProductDto productDto = new ShoppingCartProductDto();
        productDto.setId("p00001");
        productDto.setQty(1);
        productDto.setSpecId("pro001");
        List<ExtraProductDto> extraProductDtos = Lists.newArrayList();
        ExtraProductDto extraProductDto = new ExtraProductDto();
        extraProductDto.setId("pro001001");
        extraProductDto.setQty(1);
        extraProductDtos.add(extraProductDto);
        extraProductDto = new ExtraProductDto();
        extraProductDto.setId("pro001002");
        extraProductDto.setQty(1);
        extraProductDtos.add(extraProductDto);
        extraProductDto = new ExtraProductDto();
        extraProductDto.setId("pro001003");
        extraProductDto.setQty(1);
        extraProductDtos.add(extraProductDto);
        productDto.setAddExtra(extraProductDtos);
        productDtos.add(productDto);
        addShoppingCartRequestDto.setProducts(productDtos);
        ObjectMapper objectMapper = new ObjectMapper();

        System.out.println("json===" + objectMapper.writeValueAsString(addShoppingCartRequestDto));
        ShoppingCartInfoDto shoppingCart = cartClient.addShoppingCart(addShoppingCartRequestDto);
        System.out.println("jsonObject===" + shoppingCart);

    }

    @Test
    public void getDetailTest(){
        String storeId="fm001";
        String userId="wx001";
        String merChant_id="2343242";
        GetShoppingCartDto getShoppingCartDto=new GetShoppingCartDto();
        getShoppingCartDto.setUserId(userId);
        getShoppingCartDto.setStoreId(storeId);
        getShoppingCartDto.setMerchantId(merChant_id);
        ShoppingCartInfoDto shoppingCartInfoDto=cartClient.getShoppingCart(getShoppingCartDto);
        System.out.println("json=="+shoppingCartInfoDto);

    }

    @Test
    public void updateShoppingCart() {
        UpdateShoppingCartRequestDto updateShoppingCartRequestDto = new UpdateShoppingCartRequestDto();
        updateShoppingCartRequestDto.setMerchantId("2343242");
        updateShoppingCartRequestDto.setUserId("wx001");
        updateShoppingCartRequestDto.setStoreId("fm001");
        updateShoppingCartRequestDto.setCartProductId("110129854157947138");
        updateShoppingCartRequestDto.setQty(2);
        ShoppingCartBaseResponse shoppingCartBaseResponse = cartClient.updateShoppingCart(updateShoppingCartRequestDto);
        System.out.println("json==" + shoppingCartBaseResponse);
    }

    @Test
    public void dateTest() throws ParseException {
        String date = "2018-06-10 24:00:00";
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date endTime = df.parse(date);
        System.out.println("date===" + endTime);
    }

    @Test
    public void getDetails(){




    }

}
